package org.rest.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import org.rest.dao.PemesananDAO;
import org.rest.model.Pemesanan;

@Path("/pemesanans")
public class PemesanansResource {

    @Context
    UriInfo uriInfo;
    @Context
    Request request;

    @GET
    @Produces(MediaType.TEXT_XML)
    public List<Pemesanan> getAllPemesanans() {
        List<Pemesanan> pemesanans = new ArrayList<Pemesanan>();
        pemesanans.addAll(PemesananDAO.intance.getModel());
        return pemesanans;
    }

    @GET
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public List<Pemesanan> getPemesanans() {
        List<Pemesanan> pemesanans = new ArrayList<Pemesanan>();
        pemesanans.addAll(PemesananDAO.intance.getModel());
        return pemesanans;
    }

    @GET
    @Path("jumlah")
    @Produces(MediaType.TEXT_PLAIN)
    public String getJumlahPemesanan() {
        int jumlah = PemesananDAO.intance.getModel().size();
        return String.valueOf(jumlah);
    }

    @Path("{pemesanan}")
    public PemesananResource getPemesanan(@PathParam("pemesanan") int id) {
        return new PemesananResource(uriInfo, request, id);
    }
}
