 <?php

use yii\widgets\DetailView;
use app\models\Sekolah;
use app\models\SekolahSearch;
use yii\grid\GridView;
use yii\data\ActiveDataProvider;
use yii\helpers\Html;
use yii\bootstrap\Carousel;
use app\models\DefaultBlog;

use yii\helpers\Url;


//use kartik\widgets\StarRating;
use yii\web\JsExpression;
use yii\widgets\ActiveForm;
/* @var $this yii\web\View */

$this->title = 'E - Pendidikan';
?>


<?php
$script = <<< JS
$(document).ready(function(){
    setTimeout(function() {
        $('#w0-warning').fadeOut('fast');
    }, 3000); // <-- time in milliseconds
});
JS;
$this->registerJs($script, \yii\web\View::POS_END);

?>



<div class="site-index">

    <div class="container">
        <div class="row">

            <div class="col-lg-8">

                <?php
                $items = [
                    [
                        'title' => 'Sintel',
                        'href' => 'images/slider02.jpg',
                        'type' => 'image/jpg',
                        'poster' => 'images/slider02.jpg'
                    ],

                    [
                        'url' => 'images/slider02.jpg',
                        'src' => 'images/slider02.jpg',
                        'options' => array('title' => 'Camposanto monumentale (inside)')
                    ],
                    [
                        'url' => 'images/slider03.jpg',
                        'src' => 'images/slider03.jpg',
                        'options' => array('title' => 'Hafsten - Sunset')
                    ],
                    [
                        'url' => 'images/slider04.jpg',
                        'src' => 'images/slider04.jpg',
                        'options' => array('title' => 'Hafsten - Sunset')
                    ],
                ]
                ?>

            </div>
        </div>

        <hr>
        <hr>

        <div class="col-lg-4 col-xs-6">
            <!-- small box -->
            <div class="small-box bg-red">
                <div class="inner">
                    <h3>&nbsp;</h3>

                    <p><b><h4>Data</h4></b></p>
                </div>
                <div class="icon">
                    <i class="fa fa-tasks"></i>
                </div>
                <!-- <a href="#" class="small-box-footer">View Detail <i class="fa fa-arrow-circle-right"></i></a> -->
                <?= Html::a('<p style="font-size:15px;color:white"><b>'.'Data'.'</b></p>'.'<i class="fa fa-arrow-circle-right"></i>', ['site/list-izin'], ['class' => 'small-box-footer']) ?>
            </div>
        </div>

        <div class="col-lg-4 col-xs-6">
            <!-- small box -->
            <div class="small-box bg-green">
                <div class="inner">
                    <h3>&nbsp;</h3>

                    <p><b><h4></h4>Data</h4></b></p>
                </div>
                <div class="icon">
                    <i class="fa fa-credit-card"></i>
                </div>
                <!-- <a href="#" class="small-box-footer">View Detail <i class="fa fa-arrow-circle-right"></i></a> -->
                <?= Html::a('<p style="font-size:15px;color:white"><b>'.'Data'.'</b></p>'.'<i class="fa fa-arrow-circle-right"></i>', ['site/monitoring'], ['class' => 'small-box-footer']) ?>
            </div>
        </div>

    </div>

    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="col-lg-12 text-center">
                    <h2></h2>
                    <hr class="star-primary">
                </div>

            </div>
            <div class="col-md-4">
                <div class="panel panel-info">
                    <div class="panel-heading">
                        <h4><i class="fa fa-fw fa-compass"></i>TK</h4>
                    </div>
                    <div class="panel-body">
                         <?php
                      echo GridView::widget([
                        'dataProvider' => $dataProviderTK,
                        'filterModel' => $searchModel,
                        'columns' => [
                            ['class' => 'yii\grid\SerialColumn'],

                            
                            [
                             'attribute' => 'Nama Sekolah',
                            'format'=>'raw',
                             'value' => function ($data) {
                                    if($data->jenjang=='TK'){
                                        return $data->nama_sekolah;
                                    }else{
                                        return "";
                                    }}
                                
                             ],
                                            

                             [

                'class' => 'yii\grid\ActionColumn',
                'template' =>'{view}',
                'buttons' =>[
                    'view' => function ($url, $model){
                        
                            
                            return Html::a('<span class="btn btn-success btn-xs"><i class="fa fa-eye"></i></span>', $url, [
                                'title' => Yii::t('app', 'Lihat'),
                            ]);
                        
                    },
                ],
                'urlCreator' => function ($action, $model, $key, $index){
                    if($action === 'view'){

                        return Url::toRoute(['sekolah/indexsekolah','id' =>$model->id]);
                    }
                }
            ],
                            ],
                        ]);
                    ?>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="panel panel-success">
                    <div class="panel-heading">
                        <h4><i class="fa fa-fw fa-compass"></i>SD</h4>
                    </div>
                    <div class="panel-body">
                         <?php
                      echo GridView::widget([
                        'dataProvider' => $dataProviderTK,
                        'filterModel' => $searchModel,
                        'columns' => [
                            ['class' => 'yii\grid\SerialColumn'],

                            
                            [
                             'attribute' => 'Nama Sekolah',
                            'format'=>'raw',
                             'value' => function ($data) {
                                    if($data->jenjang=='SD'){
                                        return $data->nama_sekolah;
                                    }else{
                                        return "";
                                    }}
                                
                             ],

                             [

                'class' => 'yii\grid\ActionColumn',
                'template' =>'{view}',
                'buttons' =>[
                    'view' => function ($url, $model){
                        
                            
                            return Html::a('<span class="btn btn-success btn-xs"><i class="fa fa-eye"></i></span>', $url, [
                                'title' => Yii::t('app', 'Lihat'),
                            ]);
                        
                    },
                ],
                'urlCreator' => function ($action, $model, $key, $index){
                    if($action === 'view'){

                        return Url::toRoute(['sekolah/indexsekolah','id' =>$model->id]);
                    }
                }
            ],
                            ],
                        ]);
                    ?>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="panel panel-success">
                    <div class="panel-heading">
                        <h4><i class="fa fa-fw fa-compass"></i>SMP</h4>
                    </div>
                    <div class="panel-body">
                         <?php
                      echo GridView::widget([
                        'dataProvider' => $dataProviderSMP,
                        'filterModel' => $searchModel,
                        'columns' => [
                            ['class' => 'yii\grid\SerialColumn'],

                            
                            [
                             'attribute' => 'Nama Sekolah',
                            'format'=>'raw',
                             'value' => function ($data) {
                                    if($data->jenjang=='SMP'){
                                        return $data->nama_sekolah;
                                    }else{
                                        return "";
                                    }}
                                
                             ],
                                            

                           
                             [

                'class' => 'yii\grid\ActionColumn',
                'template' =>'{view}',
                'buttons' =>[
                    'view' => function ($url, $model){
                        
                            
                            return Html::a('<span class="btn btn-success btn-xs"><i class="fa fa-eye"></i></span>', $url, [
                                'title' => Yii::t('app', 'Lihat'),
                            ]);
                        
                    },
                ],
                'urlCreator' => function ($action, $model, $key, $index){
                    if($action === 'view'){

                        return Url::toRoute(['sekolah/indexsekolah','id' =>$model->id]);
                    }
                }
            ],
                            ],
                        ]);
                    ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <hr>

</div>


</div>
