<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model app\models\Sekolah */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Sekolahs', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="sekolah-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'nama_sekolah',
            'alamat_sekolah',
            [
                 'attribute' => 'Foto',
                 'format' => 'raw',
                 'value' => function ($model) {
                    if ($model->foto_sekolah!='')
                      return '<img src="'.Yii::getAlias('@web'). '/gambarsekolah/'.$model->foto_sekolah.'" width="100px" height="auto">'; else return 'no image';
                 },
            ],
            'visi',
            'misi',
            // 'created_at',
            // 'updated_at',
            // 'deleted_at',
            // 'deleted',
            // 'created_by',
            // 'updated_by',
            // 'deleted_by',
        ],
    ]) ?>

</div>
