<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;

/* @var $this \yii\web\View */
/* @var $content string */
?>
<?php
$script = <<< JS
$(document).ready(function(){
    var pathArray = window.location.pathname.split( '/' );
});
JS;
$this->registerJs($script, \yii\web\View::POS_END);
?>
<?php
if(
    Yii::$app->controller->id === 'site' && Yii::$app->controller->action->id === 'index'||
    Yii::$app->controller->id === 'site' && Yii::$app->controller->action->id === 'daftar_TK'||
    Yii::$app->controller->id === 'site' && Yii::$app->controller->action->id === 'daftar_SD'||
    Yii::$app->controller->id === 'site' && Yii::$app->controller->action->id === 'daftar_SMP'
){
    ?>
    <header class="main-header">
        <?php NavBar::begin([
            'brandLabel' => '<table><tr><td><img src="'.Yii::getAlias('@web').'/images/logo_emarsada.png'.'" 
            height="30" width="50"></td><td></td><td><b>SI-Pendidikan</b></tr></table>',
            //'brandLabel' =>'Dinas Perizinan',
            'brandUrl' => Yii::$app->homeUrl,
            'options' => [
                'class' => 'navbar navbar-static-top',
                'style'=> 'height: 60px',
            ],
        ]);


        $menuItems = [
            ['label' => 'HOME', 'url' => ['/site/index']],

            [
                'label' => 'PROFIL SI-Pendidikan ',
                'items' => [
                    ['label' => 'Data 1', 'url' => ['#']],
                    '<li class="divider"></li>',
                    ['label' => 'Data 2', 'url' => ['#']],
                    '<li class="divider"></li>',
                    ['label' => 'Data 3', 'url' => ['#']],
                ],
            ],

            ['label' => 'Daftar TK/PAUD', 'url' => ['/site/daftar_TK']],
            ['label' => 'Daftar SD', 'url' => ['/site/daftar_SD']],
            ['label' => 'Daftar SMP', 'url' => ['/site/daftar_SMP']],
            ['label' => 'LOGIN', 'url' => ['/site/about']],
        ];

        echo Nav::widget([
            'options' => ['class' => 'navbar-nav navbar-right'],

            'items' => $menuItems,
        ]);

        NavBar::end();
        ?>
    </header>
<?php } else { ?>
    <header class="main-header">

        <?= Html::a('<span class="logo-mini">SADisPen</span><span class="logo-lg">SI Pendidikan</span>', Yii::$app->homeUrl, ['class' => 'logo']) ?>

        <nav class="navbar navbar-static-top" role="navigation">

            <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
                <span class="sr-only">Toggle navigation</span>
            </a>

            <div class="navbar-custom-menu">
                <ul class="nav navbar-nav">
                    <?php
                    if(\Yii::$app->user->isGuest){

                    }
                    else{
                        ?>
                        <li class="dropdown user user-menu">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                <img src="<?= $directoryAsset ?>/img/user2-160x160.jpg" class="user-image" alt="User Image"/>
                                <span class="hidden-xs"><?= Yii::$app->user->identity->username ?></span>
                            </a>
                            <ul class="dropdown-menu">
                                <!-- User image -->
                                <li class="user-header">
                                    <img src="<?= $directoryAsset ?>/img/user2-160x160.jpg" class="img-circle"
                                         alt="User Image"/>

                                    <p>
                                        <?= Yii::$app->user->identity->username ?><br>
                                        <?= Yii::$app->user->identity->email ?>
                                    </p>
                                </li>
                                <!-- Menu Footer-->
                                <li class="user-footer">
                                    <div class="pull-left">
                                        <a href="#" class="btn btn-default btn-flat">Profile</a>
                                    </div>
                                    <div class="pull-right">
                                        <?= Html::a(
                                            'Sign out',
                                            ['/site/logout'],
                                            ['data-method' => 'post', 'class' => 'btn btn-default btn-flat']
                                        ) ?>
                                    </div>
                                </li>
                            </ul>
                        </li>
                        <?php
                    }
                    ?>
                </ul>
            </div>
        </nav>
    </header>
<?php } ?>
