<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "siswa".
 *
 * @property integer $id
 * @property string $nama
 * @property string $nis
 * @property string $nisn
 * @property string $alamat
 * @property string $foto
 * @property string $nama_ayah
 * @property string $nama_ibu
 * @property string $pekerjaan_ayah
 * @property string $pekerjaan_ibu
 * @property string $penghasilan_ortu
 * @property string $nama_wali
 * @property string $pekerjaan_wali
 * @property string $penghasilan_wali
 * @property string $created_at
 * @property string $updated_at
 * @property string $deleted_at
 * @property integer $deleted
 * @property string $created_by
 * @property string $updated_by
 * @property string $deleted_by
 */
class Siswa extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'siswa';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['nama', 'nis', 'nisn', 'alamat', 'foto', 'nama_ayah', 'nama_ibu', 'pekerjaan_ayah', 'pekerjaan_ibu', 'penghasilan_ortu', 'nama_wali', 'pekerjaan_wali', 'penghasilan_wali'], 'required'],
            [['created_at', 'updated_at', 'deleted_at'], 'safe'],
            [['deleted'], 'integer'],
            [['nama', 'nis', 'nisn', 'alamat', 'foto', 'nama_ayah', 'nama_ibu', 'pekerjaan_ayah', 'pekerjaan_ibu', 'penghasilan_ortu', 'nama_wali', 'pekerjaan_wali', 'penghasilan_wali'], 'string', 'max' => 100],
            [['created_by', 'updated_by', 'deleted_by'], 'string', 'max' => 32],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'nama' => 'Nama',
            'nis' => 'Nis',
            'nisn' => 'Nisn',
            'alamat' => 'Alamat',
            'foto' => 'Foto',
            'nama_ayah' => 'Nama Ayah',
            'nama_ibu' => 'Nama Ibu',
            'pekerjaan_ayah' => 'Pekerjaan Ayah',
            'pekerjaan_ibu' => 'Pekerjaan Ibu',
            'penghasilan_ortu' => 'Penghasilan Ortu',
            'nama_wali' => 'Nama Wali',
            'pekerjaan_wali' => 'Pekerjaan Wali',
            'penghasilan_wali' => 'Penghasilan Wali',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'deleted_at' => 'Deleted At',
            'deleted' => 'Deleted',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'deleted_by' => 'Deleted By',
        ];
    }
}
