<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "sekolah".
 *
 * @property integer $id
 * @property string $nama_sekolah
 * @property string $alamat_sekolah
 * @property string $foto_sekolah
 * @property string $visi
 * @property string $misi
 * @property string $created_at
 * @property string $updated_at
 * @property string $deleted_at
 * @property integer $deleted
 * @property string $created_by
 * @property string $updated_by
 * @property string $deleted_by
 */
class Sekolah extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'sekolah';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['nama_sekolah', 'alamat_sekolah','jenjang' ,'foto_sekolah', 'visi', 'misi'], 'required'],
            [['created_at', 'updated_at', 'deleted_at'], 'safe'],
            [['deleted'], 'integer'],
            [['nama_sekolah', 'alamat_sekolah'], 'string'],
            [[ 'visi', 'misi'], 'string', 'max' => 100],
            [['created_by', 'updated_by', 'deleted_by'], 'string', 'max' => 32],
            [['foto_sekolah'], 'file', 'extensions' => 'png, jpg, gif'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'nama_sekolah' => 'Nama Sekolah',
            'alamat_sekolah' => 'Alamat Sekolah',
            'jenjang' => 'Jenjang',
            'foto_sekolah' => 'Foto Sekolah',
            'visi' => 'Visi',
            'misi' => 'Misi',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'deleted_at' => 'Deleted At',
            'deleted' => 'Deleted',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'deleted_by' => 'Deleted By',
        ];
    }
}
