<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "jenjang".
 *
 * @property integer $id
 * @property string $jenjang
 * @property string $created_at
 * @property string $updated_at
 * @property string $deleted_at
 * @property integer $deleted
 * @property string $created_by
 * @property string $updated_by
 * @property string $deleted_by
 */
class Jenjang extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'jenjang';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'jenjang', 'created_at', 'updated_at', 'deleted_at', 'deleted', 'created_by', 'updated_by', 'deleted_by'], 'required'],
            [['id', 'deleted'], 'integer'],
            [['created_at', 'updated_at', 'deleted_at'], 'safe'],
            [['jenjang'], 'string', 'max' => 100],
            [['created_by', 'updated_by', 'deleted_by'], 'string', 'max' => 32],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'jenjang' => 'Jenjang',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'deleted_at' => 'Deleted At',
            'deleted' => 'Deleted',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'deleted_by' => 'Deleted By',
        ];
    }
}
