<?php

namespace backend\controllers;

use Yii;
use common\modules\auth\models\AuthItem;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * RbacController implements the CRUD actions for AuthItem model.
 */
class RbacController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }


    // Create user assignment
        public function actionAssigment(){

            $auth = Yii::$app->authManager;

            $admin = $auth->createRole('admin');
            $sekpentk = $auth->createRole('sekpenTK');
            $sekpensd = $auth->createRole('sekpenSD');
            $sekpensmp = $auth->createRole('sekpenSMP');

            $auth->assign($admin, 1);
            $auth->assign($sekpentk, 2);
            $auth->assign($sekpensd, 3);
            $auth->assign($sekpensmp, 4);
        }
    // Create role


    public function actionCreate_role(){
        $auth = Yii::$app->authManager;

        $index = $auth->createPermission('sekolah/index');
        $create = $auth->createPermission('sekolah/create');
        $view = $auth->createPermission('sekolah/view');
        $update = $auth->createPermission('sekolah/update');
        $delete = $auth->createPermission('sekolah/delete');

        $index_user = $auth->createPermission('users/index');
        $create_user = $auth->createPermission('users/create');
        $view_user = $auth->createPermission('users/view');
        $update_user = $auth->createPermission('users/update');
        $delete_user = $auth->createPermission('users/delete');

        $indexsekolah = $auth->createPermission('sekolah/indexsekolah');

        // add "admin" role give this role the index create view update delete

        $admin = $auth->createRole('admin');
        
        $auth->addChild($admin, $index_user);
        $auth->addChild($admin, $create_user);
        $auth->addChild($admin, $view_user);
        $auth->addChild($admin, $update_user);
        $auth->addChild($admin, $delete_user);
        $auth->addChild($admin, $indexsekolah);

        $sekpentk = $auth->createRole('sekpenTK');
        $auth->add($sekpentk);
        $auth->addChild($sekpentk, $index);
        $auth->addChild($sekpentk, $create);
        $auth->addChild($sekpentk, $view);
        $auth->addChild($sekpentk, $update);
        $auth->addChild($sekpentk, $delete);
        $auth->addChild($sekpentk, $indexsekolah);

        $sekpensd = $auth->createRole('sekpenSD');
        $auth->add($sekpensd);
        $auth->addChild($sekpensd, $index);
        $auth->addChild($sekpensd, $create);
        $auth->addChild($sekpensd, $view);
        $auth->addChild($sekpensd, $update);
        $auth->addChild($sekpensd, $delete);
        $auth->addChild($sekpensd, $indexsekolah);

        $sekpensmp = $auth->createRole('sekpenSMP');
        $auth->add($sekpensmp);
        $auth->addChild($sekpensmp, $index);
        $auth->addChild($sekpensmp, $create);
        $auth->addChild($sekpensmp, $view);
        $auth->addChild($sekpensmp, $update);
        $auth->addChild($sekpensmp, $delete);
        $auth->addChild($sekpensmp, $indexsekolah);

    }
    
    public function actionCreate_permission()
    {
        $auth = Yii::$app->authManager;


        $index = $auth->createPermission('sekolah/index');
        $index->description = ' Create a sekolah';
        $auth->add($index);

        $create = $auth->createPermission('sekolah/create');
        $create->description = ' create a sekolah';
        $auth->add($create);

        $view = $auth->createPermission('sekolah/view');
        $view->description = ' View a sekolah';
        $auth->add($view);

        $update = $auth->createPermission('sekolah/update');
        $update->description = ' Update a sekolah';
        $auth->add($update);

        $delete = $auth->createPermission('sekolah/delete');
        $delete->description = ' Delete a sekolah';
        $auth->add($delete);

        $indexSekolah = $auth->createPermission('sekolah/indexsekolah');
        $indexsekolah->description = 'view homepage a school';
        $auth->add($indexsekolah);

        /**
         * Users
         */

        $index_user = $auth->createPermission('users/index');
        $index_user->description = ' Create a User';
        $auth->add($index_user);

        $create_user = $auth->createPermission('users/create');
        $create_user->description = ' create a User';
        $auth->add($create_user);

        $view_user = $auth->createPermission('users/view');
        $view_user->description = ' View a User';
        $auth->add($view_user);

        $update_user = $auth->createPermission('users/update');
        $update_user->description = ' Update a User';
        $auth->add($update_user);

        $delete_user = $auth->createPermission('users/delete');
        $delete_user->description = ' Delete a User';
        $auth->add($delete_user);
    }
    /**
     * Lists all AuthItem models.
     * @return mixed
     */
    public function actionIndex()
    {
        $dataProvider = new ActiveDataProvider([
            'query' => AuthItem::find(),
        ]);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single AuthItem model.
     * @param string $id
     * @return mixed
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new AuthItem model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new AuthItem();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->name]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing AuthItem model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param string $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->name]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing AuthItem model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param string $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the AuthItem model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $id
     * @return AuthItem the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = AuthItem::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
