<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "pasien".
 *
 * @property integer $id_pasien
 * @property string $nama_pasien
 * @property string $alamat
 * @property string $no_telepon
 * @property string $rt_rw
 * @property integer $id_kelurahan
 * @property string $tanggal_lahir
 * @property string $jenis_kelamin
 *
 * @property Kelurahan $idKelurahan
 */
class Pasien extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'pasien';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['nama_pasien', 'alamat', 'no_telepon', 'rt_rw', 'id_kelurahan', 'tanggal_lahir', 'jenis_kelamin'], 'required'],
            [['id_kelurahan'], 'integer'],
            [['nama_pasien', 'alamat', 'no_telepon', 'rt_rw', 'tanggal_lahir', 'jenis_kelamin'], 'string', 'max' => 225],
            [['id_kelurahan'], 'unique'],
            [['id_kelurahan'], 'exist', 'skipOnError' => true, 'targetClass' => Kelurahan::className(), 'targetAttribute' => ['id_kelurahan' => 'id_kelurahan']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id_pasien' => 'Id Pasien',
            'nama_pasien' => 'Nama Pasien',
            'alamat' => 'Alamat',
            'no_telepon' => 'No Telepon',
            'rt_rw' => 'Rt Rw',
            'id_kelurahan' => 'Id Kelurahan',
            'tanggal_lahir' => 'Tanggal Lahir',
            'jenis_kelamin' => 'Jenis Kelamin',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getIdKelurahan()
    {
        return $this->hasOne(Kelurahan::className(), ['id_kelurahan' => 'id_kelurahan']);
    }
}
