<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "kelurahan".
 *
 * @property integer $id_kelurahan
 * @property string $nama_kelurahan
 * @property string $nama_kecamatan
 * @property string $nama_kota
 *
 * @property Pasien $pasien
 */
class Kelurahan extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'kelurahan';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['nama_kelurahan', 'nama_kecamatan', 'nama_kota'], 'required'],
            [['nama_kelurahan', 'nama_kecamatan', 'nama_kota'], 'string', 'max' => 100],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id_kelurahan' => 'Id Kelurahan',
            'nama_kelurahan' => 'Nama Kelurahan',
            'nama_kecamatan' => 'Nama Kecamatan',
            'nama_kota' => 'Nama Kota',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPasien()
    {
        return $this->hasOne(Pasien::className(), ['id_kelurahan' => 'id_kelurahan']);
    }
}
