﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class BackgroundChanger : MonoBehaviour {

    private List<GameObject> backgroundGroup = new List<GameObject>();
    private List<GameObject> obstacleGroup = new List<GameObject>();
    private GameObject[] gameObjectGroup;
    private GameObject background;
    private string[] colors = {"Blue", "Green" };
        
    public void Start()
    {
        CollectBackgrounds();
        CollectObstacles();
        UpdateBackgroud(colors[0]);
    }

    private void CollectBackgrounds()
    {
        foreach(string color in colors)
        {
            background = GameObject.FindWithTag(color + "Background");
            backgroundGroup.Add(background);
        }
    }

    private void CollectObstacles()
    {
        foreach(string color in colors)
        {
            gameObjectGroup = GameObject.FindGameObjectsWithTag(color + "Obstacle");
            foreach(GameObject obstacle in gameObjectGroup)
            {
                obstacleGroup.Add(obstacle);
            }
        }
    }

    public void Update()
    {
        if (Input.GetKey(KeyCode.X))
        {
            UpdateBackgroud("Blue");
        } else if (Input.GetKey(KeyCode.Z))
        {
            UpdateBackgroud("Green");
        }
    }

    public void UpdateBackgroud(string tagColor)
    {
        foreach(GameObject background in backgroundGroup)
        {
            if (background.tag == tagColor + "Background")
            {
                background.SetActive(true);
            } else
            {
                background.SetActive(false);
            }
        }

        UpdateObstacle(tagColor);
    }

    private void UpdateObstacle(string tagColor)
    { 
        foreach (GameObject obstacle in obstacleGroup)
        {
            if(obstacle.tag == tagColor + "Obstacle")
            {
                obstacle.SetActive(false);
            } else
            {
                obstacle.SetActive(true);
            }
        }
    }
}
