﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class BackgroundChanger : MonoBehaviour {


    private List<GameObject> backgroundGroup = new List<GameObject>();
    private List<GameObject> obstacleGroup = new List<GameObject>();
    private GameObject[] gameObjectGroup;
    private GameObject background;
    private string[] colors = {"Blue", "Green", "Yellow" };
        
    public void Start()
    {
        CollectBackgrounds();
        CollectObstacles();
        UpdateBackgroud(colors[0]);
    }

	private void CollectBackgrounds()
	{
		background = GameObject.FindWithTag("Background");
	}
		

    private void CollectObstacles()
    {
        foreach(string color in colors)
        {
            gameObjectGroup = GameObject.FindGameObjectsWithTag(color + "Obstacle");
            foreach(GameObject obstacle in gameObjectGroup)
            {
                obstacleGroup.Add(obstacle);
            }
        }
    }
		
    public void Update()
    {
        if (Input.GetKey(KeyCode.X))
        {
            UpdateBackgroud("Blue");
        } else if (Input.GetKey(KeyCode.Z))
        {
            UpdateBackgroud("Green");
        } else if (Input.GetKey(KeyCode.C))
        {
            UpdateBackgroud("Yellow");
        }
    }

    public void UpdateBackgroud(string tagColor)
    {
        if(tagColor == "Green")
        {
            background.GetComponent<SpriteRenderer>().color = new Color32(46, 204, 113, 255);
        } else if (tagColor == "Blue")
        {
            background.GetComponent<SpriteRenderer>().color = new Color32(65, 131, 215, 255);
        } else if (tagColor == "Yellow")
        {
            background.GetComponent<SpriteRenderer>().color = new Color32(255, 193, 7, 255);
        }


        UpdateObstacle(tagColor);
    }


	private void UpdateObstacle(string tagColor)
	{ 
		foreach (GameObject obstacle in obstacleGroup)
		{
			if (obstacle.tag == tagColor + "Obstacle")
			{
				obstacle.SetActive(false);
			} else
			{
				obstacle.SetActive(true);
			}
		}
	}
}
