package model.response

import android.os.Parcel
import android.os.Parcelable
import com.google.gson.annotations.SerializedName
import kotlinx.android.parcel.Parcelize

@Parcelize
data class ResponsePaket(
    val status: Long,
    val data: DataPaket,
    val message: String
) : Parcelable

@Parcelize
data class DataPaket(
    val myPaket: List<Paket>,
    val otherPaket: List<Paket>
) : Parcelable

@Parcelize
data class Paket(
    @field:SerializedName("namaPenerima")
    val namaPenerima: String? = null,

    @field:SerializedName("tag")
    val tag: String,

    @field:SerializedName("status")
    val status: String,

    @field:SerializedName("waktuKedatangan")
    val waktuKedatangan: String,

    @field:SerializedName("deskripsi")
    val deskripsi: String,

    @field:SerializedName("pengirim")
    val pengirim: String,

    @field:SerializedName("id")
    val id : String
) : Parcelable