package ta1.cis.model.response

import android.os.Parcelable
import com.google.gson.annotations.SerializedName
import kotlinx.android.parcel.Parcelize

@Parcelize
data class ResponseDataAsrama(

	@field:SerializedName("data")
	val data: DataAsrama? = null,

	@field:SerializedName("message")
	val message: String? = null,

	@field:SerializedName("status")
	val status: Int? = null
) : Parcelable

@Parcelize
data class Asrama(

	@field:SerializedName("nama_asrama")
	val namaAsrama: String? = null,

	@field:SerializedName("lokasi_asrama")
	val lokasiAsrama: String? = null,

	@field:SerializedName("kamar_id")
	val kamarId: String? = null,

	@field:SerializedName("kamar")
	val kamar: String? = null,

	@field:SerializedName("asrama_id")
	val asramaId: String? = null
) : Parcelable

@Parcelize
data class DataAsrama(

	@field:SerializedName("teman_sekamar")
	val temanSekamar: List<TemanSekamarItem>,

	@field:SerializedName("asrama")
	val asrama: Asrama,

	@field:SerializedName("pembinaAsrama")
	val pembinaAsrama: List<PembinaAsramaItem>
) : Parcelable

@Parcelize
data class TemanSekamarItem(

	@field:SerializedName("nama")
	val nama: String? = null,

	@field:SerializedName("tahun_masuk")
	val tahunMasuk: String? = null,

	@field:SerializedName("prodi")
	val prodi: String? = null
) : Parcelable

@Parcelize
data class PembinaAsramaItem(

	@field:SerializedName("nama")
	val nama: String? = null
) : Parcelable
