package ta1.cis.fragment.tabitem

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.util.Log
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import ta1.cis.api.RetrofitInstance
import ta1.cis.api.Constants
import com.bumptech.glide.Glide
import ta1.cis.helper.SharedPref
import kotlinx.android.synthetic.main.d__pribadi.*
import kotlinx.android.synthetic.main.d__pribadi.progressBar
import ta1.cis.model.response.ResponseDataPribadi
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import ta1.cis.R
import ta1.cis.activity.EditDataPribadiActivity


class D_PribadiFragment : Fragment() {
    private lateinit var sharedPref: SharedPref
    private lateinit var nama : TextView
    private lateinit var ttl : TextView
    private lateinit var jkelamin : TextView
    private lateinit var alamat : TextView
    private lateinit var agama : TextView
    private lateinit var goldrh : TextView
    private lateinit var kbpaten : TextView
    private lateinit var kodepos : TextView
    private lateinit var emailpribadi : TextView
    private lateinit var hp1 : TextView
    private lateinit var hp2 : TextView
    private lateinit var anakke : TextView
    private lateinit var foto : ImageView
    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        sharedPref = SharedPref(activity as Context)
        return inflater.inflate(R.layout.d__pribadi, container, false)
    }

    override fun onStart() {
        super.onStart()
        if(sharedPref.getStatusUpdate() == 2){
            sharedPref.setStatusUpdate(1)
            fetchData()
        }
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        nama = view.findViewById(R.id.nama)
        ttl = view.findViewById(R.id.ttl)
        jkelamin = view.findViewById(R.id.jkelamin)
        alamat = view.findViewById(R.id.alamat)
        agama = view.findViewById(R.id.agama)
        goldrh = view.findViewById(R.id.goldrh)
        kbpaten = view.findViewById(R.id.kabupaten)
        kodepos = view.findViewById(R.id.kdpos)
        emailpribadi = view.findViewById(R.id.emailpribadi)
        hp1 = view.findViewById(R.id.hp1)
        hp2 = view.findViewById(R.id.hp2)
        anakke = view.findViewById(R.id.anak_ke)
        foto = view.findViewById(R.id.fotoPribadi)

        progressBar.visibility = View.VISIBLE
        fetchData();

        btneditpribadi.setOnClickListener{
            var intent = Intent(activity, EditDataPribadiActivity::class.java)

            intent.putExtra("Nama", nama.text.toString())

            intent.putExtra("Tempat_Tanggal_Lahir", ttl.text.toString())

            intent.putExtra("Jenis_Kelamin", jkelamin.text.toString())

            intent.putExtra("Agama", agama.text.toString())

            intent.putExtra("Gol_Darah", goldrh.text.toString())

            intent.putExtra("Alamat", alamat.text.toString())

            intent.putExtra("Kabupaten", kbpaten.text.toString())

            intent.putExtra("Kode_Pos", kodepos.text.toString())

            intent.putExtra("Email", emailpribadi.text.toString())

            intent.putExtra("Hp1", hp1.text.toString())

            intent.putExtra("Hp2", hp2.text.toString())

            intent.putExtra("Anak_ke", anakke.text.toString())

            startActivity(intent)
        }

//        var intent = Intent()
//        val NamaSiswa = intent.getStringExtra("Nama_Siswa")
//        nama.setText(NamaSiswa)
        super.onViewCreated(view, savedInstanceState)
    }

    private fun fetchData(){
        RetrofitInstance.instanceRetrofit.getDataPribadi("Bearer ${sharedPref.getTokenBearer()}").enqueue(object : Callback<ResponseDataPribadi>{
            override fun onResponse(call: Call<ResponseDataPribadi>, response: Response<ResponseDataPribadi>) {
                progressBar.visibility = View.GONE

                nama.text = response.body()?.data?.nama_mahasiswa
                ttl.text = "${response.body()?.data?.tempat_lahir} / ${response.body()?.data?.tanggal_lahir}"
                jkelamin.text = response.body()?.data?.jenis_kelamin
                alamat.text = response.body()?.data?.alamat
                agama.text = response.body()?.data?.agama
                goldrh.text = response.body()?.data?.gol_darah
                kbpaten.text = response.body()?.data?.kabupaten
                kodepos.text = response.body()?.data?.kode_pos
                emailpribadi.text = response.body()?.data?.email
                hp1.text = response.body()?.data?.hp
                hp2.text = response.body()?.data?.hp2
                anakke.text = "${response.body()?.data?.anak_ke} / ${response.body()?.data?.dari_jlh_anak}"
                val foto1 :String = Constants.URLFileOrImage+"${response.body()?.data?.kode_foto}"
                sharedPref.setTempat(response.body()?.data?.tempat_lahir)
                sharedPref.setTanggal(response.body()?.data?.tanggal_lahir)
                Glide.with(activity as Context)
                    .load(foto1)
                    .placeholder(R.drawable.loading)
                    .centerCrop()
                    .into(foto)

            }

            override fun onFailure(call: Call<ResponseDataPribadi>, t: Throwable) {
                progressBar.visibility = View.GONE
                Log.d("Error ",t.message.toString())
            }
        });
    }
}