package ta1.cis.fragment.tabitem

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import android.widget.Toast
import androidx.fragment.app.Fragment
import kotlinx.android.synthetic.main.d__orang_tua.*
import kotlinx.android.synthetic.main.d__pribadi.progressBar
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import ta1.cis.R
import ta1.cis.activity.EditDataOrangtuaActivity
import ta1.cis.api.RetrofitInstance
import ta1.cis.helper.SharedPref
import ta1.cis.model.response.ResponseDataOrangtua


class D_OrangTuaFragment : Fragment() {
    private lateinit var sharedPref: SharedPref
    private lateinit var namaayah : TextView
    private lateinit var namaibu : TextView
    private lateinit var alamatortu : TextView
    private lateinit var pekerjaanayah : TextView
    private lateinit var ketpekerjaanayah : TextView
    private lateinit var rentpenghasilanyah : TextView
    private lateinit var pengpastiayah : TextView
    private lateinit var nohpayah : TextView
    private lateinit var pekerjaanibu : TextView
    private lateinit var ketpekerjaanibu : TextView
    private lateinit var rentpenghasilanibu : TextView
    private lateinit var pengpastiibu : TextView
    private lateinit var nohpibu : TextView
    private lateinit var jlhtanggungan : TextView
    private lateinit var namawali : TextView
    private lateinit var alamatwali : TextView
    private lateinit var pekerjaanwali : TextView
    private lateinit var ketpekerjaanwali : TextView
    private lateinit var rentpenghasilanwali : TextView
    private lateinit var pengpastiwali : TextView
    private lateinit var nohpwali : TextView
    private lateinit var totalPenghasilan : TextView

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        sharedPref = SharedPref(activity as Context)
        return inflater.inflate(R.layout.d__orang_tua, container, false)
    }

    override fun onStart() {
        super.onStart()
            fetchData()
            sharedPref.setStatusUpdate(1)
    }

//    override fun onResume() {
//        super.onResume()
//        fetchData()
//    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        namaayah = view.findViewById(R.id.namaayah)
        namaibu = view.findViewById(R.id.namaibu)
        alamatortu = view.findViewById(R.id.alamatortu)
        pekerjaanayah = view.findViewById(R.id.pekerjaanayah)
        ketpekerjaanayah = view.findViewById(R.id.ketpekerjaanayah)
        rentpenghasilanyah = view.findViewById(R.id.rentpenghasilanayah)
        pengpastiayah = view.findViewById(R.id.penghasilanpastiayah)
        nohpayah = view.findViewById(R.id.hpayah)
        pekerjaanibu = view.findViewById(R.id.pekerjaanibu)
        ketpekerjaanibu = view.findViewById(R.id.ketpekerjaanibu)
        rentpenghasilanibu = view.findViewById(R.id.rentpenghasilanibu)
        pengpastiibu = view.findViewById(R.id.penghasilanpastiibu)
        nohpibu = view.findViewById(R.id.hpibu)
        jlhtanggungan = view.findViewById(R.id.jlhtanggungan)
        namawali = view.findViewById(R.id.namawali)
        alamatwali = view.findViewById(R.id.alamatwali)
        pekerjaanwali = view.findViewById(R.id.pekerjaanwali)
        ketpekerjaanwali = view.findViewById(R.id.ketpekerjaanwali)
        rentpenghasilanwali = view.findViewById(R.id.rentpenghasilanwali)
        pengpastiwali = view.findViewById(R.id.penghasilanpastiwali)
        nohpwali = view.findViewById(R.id.hpwali)
        totalPenghasilan = view.findViewById(R.id.totalpenghasilan)

        progressBar.visibility = View.VISIBLE
        fetchData()
        btneditorangtua.setOnClickListener {
            var intent = Intent(activity, EditDataOrangtuaActivity::class.java)

            intent.putExtra("Nama_Ayah", namaayah.text.toString())

            intent.putExtra("Nama_Ibu", namaibu.text.toString())

            intent.putExtra("No_Hp_Ayah", nohpayah.text.toString())

            intent.putExtra("No_Hp_Ibu", nohpibu.text.toString())

            intent.putExtra("Alamat_Ortu", alamatortu.text.toString())

            intent.putExtra("Pekerjaan_Ayah", pekerjaanayah.text.toString())

            intent.putExtra("Keterangan_Pekerjaan_Ayah", ketpekerjaanayah.text.toString())

            intent.putExtra("Rentang_Penghasilan_Ayah", rentpenghasilanyah.text.toString())

            intent.putExtra("Penghasilan_Pasti_Ayah", pengpastiayah.text.toString())

            intent.putExtra("Pekerjaan_Ibu", pekerjaanibu.text.toString())

            intent.putExtra("Keterangan_Pekerjaan_Ibu", ketpekerjaanibu.text.toString())

            intent.putExtra("Rentang_Penghasilan_Ibu", rentpenghasilanibu.text.toString())

            intent.putExtra("Penghasilan_Pasti_Ibu", pengpastiibu.text.toString())

            intent.putExtra("Total_Pendapatan_Ortu", totalPenghasilan.text.toString())

            intent.putExtra("Jumlah_Tanggungan", jlhtanggungan.text.toString())

            intent.putExtra("Nama_Wali", namawali.text.toString())

            intent.putExtra("Alamat_Wali", alamatwali.text.toString())

            intent.putExtra("Pekerjaan_Wali", pekerjaanwali.text.toString())

            intent.putExtra("Keterangan_Pekerjaan_Wali", ketpekerjaanwali.text.toString())

            intent.putExtra("Rentang_Penghasilan_Wali", rentpenghasilanwali.text.toString())

            intent.putExtra("Penghasilan_Pasti_Wali", pengpastiwali.text.toString())

            intent.putExtra("No_Hp_Wali", nohpwali.text.toString())
            startActivity(intent)
        }
        super.onViewCreated(view, savedInstanceState)
    }

    private fun fetchData(){
        RetrofitInstance.instanceRetrofit.getDataOrangtua("Bearer ${sharedPref.getTokenBearer()}").enqueue(object : Callback<ResponseDataOrangtua>{
            override fun onResponse(call: Call<ResponseDataOrangtua>, response: Response<ResponseDataOrangtua>) {

                namaayah.text = response.body()?.data?.nama_ayah ?: "-"
                namaibu.text = response.body()?.data?.nama_ibu ?: "-"
                alamatortu.text = response.body()?.data?.alamat_orangtua ?: "-"
                pekerjaanayah.text = response.body()?.data?.pekerjaan_ayah ?: "-"
                ketpekerjaanayah.text = response.body()?.data?.keterangan_pekerjaan_ayah ?: "-"
                rentpenghasilanyah.text = response.body()?.data?.rentang_penghasilan_ayah ?: "-"
                pengpastiayah.text = response.body()?.data?.penghasilan_ayah ?: "-"
                nohpayah.text = response.body()?.data?.no_hp_ayah ?: "-"
                pekerjaanibu.text = response.body()?.data?.pekerjaan_ibu ?: "-"
                ketpekerjaanibu.text = response.body()?.data?.keterangan_pekerjaan_ibu ?: "-"
                rentpenghasilanibu.text = response.body()?.data?.rentang_penghasilan_ibu ?: "-"
                pengpastiibu.text = response.body()?.data?.penghasilan_ibu ?: "-"
                nohpibu.text = response.body()?.data?.no_hp_ibu ?: "-"
                jlhtanggungan.text = response.body()?.data?.jumlah_tanggungan ?: "-"
                namawali.text = response.body()?.data?.nama_wali ?: "-"
                alamatwali.text = response.body()?.data?.alamat_wali ?: "-"
                pekerjaanwali.text = response.body()?.data?.pekerjaan_wali ?: "-"
                ketpekerjaanwali.text = response.body()?.data?.keterangan_pekerjaan_wali ?: "-"
                rentpenghasilanwali.text = response.body()?.data?.rentang_penghasilan_wali ?: "-"
                pengpastiwali.text = response.body()?.data?.penghasilan_wali ?: "-"
                nohpwali.text = response.body()?.data?.no_hp_wali ?: "-"
                val penghasilan : Long = pengpastiayah.text.toString().toLong() + pengpastiibu.text.toString().toLong()
                totalPenghasilan.text = penghasilan.toString()
                progressBar.visibility = View.GONE

            }

            override fun onFailure(call: Call<ResponseDataOrangtua>, t: Throwable) {
                progressBar.visibility = View.GONE
                Log.d("Error ",t.message.toString())
            }

        });
    }
}