package ta1.cis.fragment.tabitem

import android.content.Context
import android.os.Bundle
import android.util.Log
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import kotlinx.android.synthetic.main.d__asrama.*
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import ta1.cis.R
import ta1.cis.api.RetrofitInstance
import ta1.cis.helper.SharedPref
import ta1.cis.model.response.ResponseDataAsrama


class D_AsramaFragment : Fragment() {
    private lateinit var sharedPref: SharedPref
    private lateinit var NamaAsrama : TextView
    private lateinit var PengurusAsrama : TextView
    private lateinit var Kamar : TextView
    private lateinit var TmnSekamar : TextView

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
    }
    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        sharedPref = SharedPref(activity as Context)
        return inflater.inflate(R.layout.d__asrama, container, false)
    }



    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        NamaAsrama = view.findViewById(R.id.nmAsrama)
//        PengurusAsrama = view.findViewById(R.id.pengurusAsrama)
        Kamar = view.findViewById(R.id.kamar)
        TmnSekamar = view.findViewById(R.id.tmanSekamar)

        progressBar.visibility = View.VISIBLE
        RetrofitInstance.instanceRetrofit.getDataAsrama("Bearer ${sharedPref.getTokenBearer()}").enqueue(object : Callback<ResponseDataAsrama>{
            override fun onResponse(
                call: Call<ResponseDataAsrama>,
                response: Response<ResponseDataAsrama>
            ) {
                progressBar.visibility = View.GONE
                var data = response.body()?.data
                NamaAsrama.text = "${data?.asrama?.namaAsrama} , ${data?.asrama?.lokasiAsrama}"
                var namaPembina = ""
                var count = 0;
                data?.pembinaAsrama?.forEach {
                    namaPembina += "- ${it.nama}"
                        namaPembina += "\n"
                    count++
                }
                pembina.text = namaPembina
                Kamar.text = data?.asrama?.kamar

                var namaTemanSekamar = ""
                count = 0
                data?.temanSekamar?.forEach {
                    namaTemanSekamar += "- ${it.nama}"
                        namaTemanSekamar += "\n"

                    count++
                }
                tmanSekamar.text = namaTemanSekamar
            }

            override fun onFailure(call: Call<ResponseDataAsrama>, t: Throwable) {
                progressBar.visibility = View.GONE
                Log.d("Error", t.message.toString())
            }
        });
        super.onViewCreated(view, savedInstanceState)
    }

}