package ta1.cis.fragment.tabitem

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.util.Log
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.navigation.NavController
import kotlinx.android.synthetic.main.d__akademis.*
import ta1.cis.api.RetrofitInstance
import ta1.cis.helper.SharedPref
import kotlinx.android.synthetic.main.d__pribadi.progressBar
import ta1.cis.model.response.ResponseDataAkademis
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import ta1.cis.R
import ta1.cis.activity.EditDataPribadiActivity


class D_AkademisFragment : Fragment(){
    private lateinit var sharedPref: SharedPref
    private lateinit var statusakhir : TextView
    private lateinit var angkatan : TextView
    private lateinit var username : TextView
    private lateinit var emailakademik : TextView
    private lateinit var progstudi : TextView
    private lateinit var kelas : TextView
    private lateinit var walimahasiswa : TextView
    private lateinit var jalurusm : TextView
    private var navController:NavController ?=null

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        sharedPref = SharedPref(activity as Context)
        return inflater.inflate(R.layout.d__akademis, container, false)

    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        statusakhir = view.findViewById(R.id.statusakhir)
        angkatan = view.findViewById(R.id.angkatan)
        username = view.findViewById(R.id.username)
        emailakademik = view.findViewById(R.id.emailakademik)
        progstudi = view.findViewById(R.id.progstudi)
        kelas = view.findViewById(R.id.kelas)
        walimahasiswa = view.findViewById(R.id.walimahasiswa)
        jalurusm = view.findViewById(R.id.jlrusm)


        progressBar.visibility = View.VISIBLE
        RetrofitInstance.instanceRetrofit.getDataAkademis("Bearer ${sharedPref.getTokenBearer()}").enqueue(object : Callback<ResponseDataAkademis>{
            override fun onResponse(call: Call<ResponseDataAkademis>, response: Response<ResponseDataAkademis>) {
                progressBar.visibility = View.GONE

                statusakhir.text = response.body()?.data?.status_akhir
                angkatan.text = response.body()?.data?.thn_masuk
                username.text = response.body()?.data?.user_name
                emailakademik.text = response.body()?.data?.email_akademik
                progstudi.text = response.body()?.data?.prodi
                kelas.text = response.body()?.data?.kelas
                walimahasiswa.text = response.body()?.data?.wali_mahasiswa
                jalurusm.text = response.body()?.data?.jalur
            }

            override fun onFailure(call: Call<ResponseDataAkademis>, t: Throwable) {
                progressBar.visibility = View.GONE
                Log.d("Error ",t.message.toString())
            }

        });
        super.onViewCreated(view, savedInstanceState)
    }
}