package ta1.cis.fragment

import android.content.Context
import android.os.Bundle
import android.util.Log
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.AdapterView
import android.widget.ArrayAdapter
import android.widget.Spinner
import android.widget.Toast
import androidx.core.view.get
import androidx.recyclerview.widget.LinearLayoutManager
import kotlinx.android.synthetic.main.fragment_perkuliahan.*
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import ta1.cis.R
import ta1.cis.adapter.PerkuliahanAdapter
import ta1.cis.adapter.SpinnerProdiAdapter
import ta1.cis.api.RetrofitInstance
import ta1.cis.helper.SharedPref
import ta1.cis.model.request.PerkuliahanHeader
import ta1.cis.model.response.HeaderItem
import ta1.cis.model.response.ResponsePerkuliahan
import ta1.cis.model.staticdata.ProdiData

class PerkuliahanFragment : Fragment() {

    private lateinit var ThnKurikulumSpin: Spinner
    private lateinit var JenProdiSpin: Spinner
    private lateinit var sharedPref:SharedPref
    private lateinit var tahunKur: String
    private lateinit var namaProdi:String
    private  var prodiId: Int = 0
    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment

        return inflater.inflate(R.layout.fragment_perkuliahan, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        var data = initList();
        ThnKurikulumSpin = view.findViewById(R.id.spinner_thnKurikulum)
        JenProdiSpin = view.findViewById(R.id.spinner_prodiJenjang)
        var adapter = SpinnerProdiAdapter(requireActivity().applicationContext,0,data)
        JenProdiSpin.adapter = adapter
        JenProdiSpin.onItemSelectedListener = object : AdapterView.OnItemSelectedListener{
            override fun onItemSelected(
                parent: AdapterView<*>?,
                view: View?,
                position: Int,
                id: Long
            ) {
                val type = parent?.getItemAtPosition(position) as ProdiData;
                prodiId = type?.value
                namaProdi = type.prodi
            }

            override fun onNothingSelected(parent: AdapterView<*>?) {
                TODO("Not yet implemented")
            }
        }
        context?.let { initSpinnerTahun(it) }
        ThnKurikulumSpin.onItemSelectedListener = object : AdapterView.OnItemSelectedListener{
            override fun onItemSelected(
                parent: AdapterView<*>?,
                view: View?,
                position: Int,
                id: Long
            ) {
                var selected = parent?.getItemAtPosition(position).toString()
                tahunKur = selected
            }

            override fun onNothingSelected(parent: AdapterView<*>?) {
                TODO("Not yet implemented")
            }
        }
        sharedPref = SharedPref(activity as Context)
        btn_cariKuliah.setOnClickListener {
            pb_perkuliahan.visibility = View.VISIBLE
            sendData(prodiId,tahunKur)
        }

    }

    private fun sendData(prodiId: Int, tahunKur: String) {
        RetrofitInstance.instanceRetrofit.getMatkulBasedOnYearAndCollege(tahunKur,prodiId,"Bearer ${sharedPref.getTokenBearer()}")
            .enqueue(object : Callback<ResponsePerkuliahan>{
                override fun onResponse(
                    call: Call<ResponsePerkuliahan>,
                    response: Response<ResponsePerkuliahan>
                ) {
                    var data = response.body()?.data
                    desk1.text = "Data Kurikulum Tahun $tahunKur"
                    desk1.visibility = View.VISIBLE
                    deskProdi.text = "Jenjang Prodi ${namaProdi}"
                    recyclerViewPerkuliahan.apply{
                        layoutManager = LinearLayoutManager(activity,LinearLayoutManager.VERTICAL,false)
                        adapter = PerkuliahanAdapter(activity as Context, data as List<HeaderItem>)
                    }

                    pb_perkuliahan.visibility = View.GONE
                }

                override fun onFailure(call: Call<ResponsePerkuliahan>, t: Throwable) {
                    Toast.makeText(activity,t.toString(),Toast.LENGTH_SHORT).show()
                    pb_perkuliahan.visibility = View.GONE
                }
            })
    }

    private fun initSpinnerTahun(context: Context){
        ArrayAdapter.createFromResource(context,R.array.list_Tahun_Kurikulum,android.R.layout.simple_spinner_item)
            .also {
                it.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
                ThnKurikulumSpin.adapter = it
            }
    }

    private fun initList(): MutableList<ProdiData> {
        var prodiList : MutableList<ProdiData> = mutableListOf()
        var listData = listOf<ProdiData>(ProdiData(
            1,
            "D3 Teknologi Informasi",
            1
        ),ProdiData(
            null,
            "D3 Teknologi Komputer",
            2
        ),ProdiData(
            2,
            "D4 Teknologi Rekayasa Perangkat lunak",
            3
        ),ProdiData(
            3,
            "S1 Informatika",
            4
        ),ProdiData(
            null,
            "S1 Manajemen Rekayasa",
            5
        ),ProdiData(
            null,
            "S1 Sistem Informasi",
            6
        ),ProdiData(
            null,
            "S1 Teknik Bioproses",
            7
        ),ProdiData(
            null,
            "S1 Teknik Elektro",
            8
        ))
        prodiList.addAll(listData)
        return prodiList
    }

//    private fun bindData(tahun:String,prodi:Int){
//        RetrofitInstance.instanceRetrofit.getMatkulBasedOnYearAndCollege(tahun,prodi)
//    }

}