package ta1.cis.fragment

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.util.Log
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import androidx.navigation.NavController
import androidx.navigation.Navigation
import androidx.recyclerview.widget.LinearLayoutManager
import kotlinx.android.synthetic.main.fragment_i_b.*
import kotlinx.android.synthetic.main.fragment_i_k.*
import kotlinx.android.synthetic.main.fragment_i_k.alertData
import kotlinx.android.synthetic.main.fragment_i_k.progressBarIzin
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import ta1.cis.R
import ta1.cis.activity.DetailIzinBermalam
import ta1.cis.activity.DetailIzinKeluar
import ta1.cis.adapter.IzinBermalamAdapter
import ta1.cis.adapter.IzinKeluarAdapter
import ta1.cis.api.RetrofitInstance
import ta1.cis.helper.SharedPref
import ta1.cis.model.response.DataIzin
import ta1.cis.model.response.DataIzinKeluar
import ta1.cis.model.response.ResponseIzinBermalam
import ta1.cis.model.response.ResponseIzinKeluar

class IKFragment : Fragment() {

    private lateinit var izinKeluarAdapter: IzinKeluarAdapter
    private lateinit var sharedPref : SharedPref
    private  var navController: NavController? =null
    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        sharedPref = SharedPref(activity as Context)
        return inflater.inflate(R.layout.fragment_i_k, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        setUpRecycle()
        loadData()
        navController = Navigation.findNavController(view)
        btn_requestIK.setOnClickListener {
            navController!!.navigate(R.id.action_nav_ik_to_requestIzinKeluarActivity)
        }
        super.onViewCreated(view, savedInstanceState)
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        swipeRefreshIK.setOnRefreshListener {
            loadData()
        }
    }

    override fun onStart() {
        super.onStart()
        loadData()
    }

    private fun setUpRecycle() {
        izinKeluarAdapter = IzinKeluarAdapter(arrayListOf())
        rv_ik.apply {
            setHasFixedSize(true)
            layoutManager = LinearLayoutManager(activity)
            adapter = izinKeluarAdapter
        }
        izinKeluarAdapter.setOnItemCallback(object : IzinKeluarAdapter.OnItemCallBack{
            override fun onItemClicked(dataIzin: DataIzinKeluar) {
//                Toast.makeText(activity,dataIzin.toString(),Toast.LENGTH_LONG).show()
                var intent = Intent(activity, DetailIzinKeluar::class.java).apply {
                    putExtra(DetailIzinKeluar.DATA_IZIN_KELUAR,dataIzin)
                }
                startActivity(intent);
            }
        })
    }
    fun loadData() {
        swipeRefreshIK.isRefreshing = true
        RetrofitInstance.instanceRetrofit.getIzinKeluar(
            sharedPref.getDimId().toLong(),
            "Bearer ${sharedPref.getTokenBearer()}"
        ).enqueue(object : Callback<ResponseIzinKeluar> {
                override fun onFailure(call: Call<ResponseIzinKeluar>, t: Throwable) {
                    Toast.makeText(activity,t.message, Toast.LENGTH_SHORT).show()

                    swipeRefreshIK.isRefreshing = false
                }

                override fun onResponse(
                    call: Call<ResponseIzinKeluar>,
                    response: Response<ResponseIzinKeluar>
                ) {
                    var list = response.body()
                    Log.d("Izin Keluar",list?.data.toString())
//                    list?.toString()?.let { Log.d("Isi data", it) }
                    if(list?.data == null){
                        alertData.visibility = View.VISIBLE
                        rv_ik.visibility = View.GONE
                    }else{
                        alertData.visibility = View.GONE
                        rv_ik.visibility = View.VISIBLE
                        izinKeluarAdapter.setData(list?.data)
                    }
                    progressBarIzin.visibility = View.GONE

                    swipeRefreshIK.isRefreshing = false
                }
            })
    }
}