package ta1.cis.fragment

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.util.Log
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.TextView
import android.widget.Toast
import androidx.navigation.NavController
import androidx.navigation.Navigation
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import ta1.cis.api.RetrofitInstance
import ta1.cis.helper.SharedPref
import kotlinx.android.synthetic.main.fragment_i_b.*
import ta1.cis.model.response.DataIzin
import ta1.cis.model.response.ResponseIzinBermalam
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import ta1.cis.R
import ta1.cis.activity.DetailIzinBermalam
import ta1.cis.adapter.IzinBermalamAdapter

class IBFragment : Fragment(),View.OnClickListener {

    private lateinit var rv:RecyclerView
    private var list = ArrayList<DataIzin>()
    private lateinit var sharedPref: SharedPref
    lateinit var ibAdapter : IzinBermalamAdapter
    private  var navController:NavController ? =null
    private lateinit var alertData : TextView
    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        sharedPref = SharedPref(activity as Context)
        return inflater.inflate(R.layout.fragment_i_b, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        rv = view.findViewById(R.id.rv_ib)
        alertData = view.findViewById(R.id.alertData)
        setUpRecycle()
        loadData()
        navController = Navigation.findNavController(view)
        view.findViewById<Button>(R.id.btn_request).setOnClickListener(this)
        super.onViewCreated(view, savedInstanceState)
    }

    override fun onStart() {
        super.onStart()
        setUpRecycle()
        loadData()
    }

    private fun setUpRecycle() {
        ibAdapter = IzinBermalamAdapter(arrayListOf())
        rv.apply {
            setHasFixedSize(true)
            layoutManager = LinearLayoutManager(activity)
            adapter = ibAdapter
        }
        ibAdapter.setOnItemCallback(object : IzinBermalamAdapter.OnItemCallBack{
            override fun onItemClicked(dataIzin: DataIzin) {
                var intent = Intent(activity,DetailIzinBermalam::class.java).apply {
                    putExtra(DetailIzinBermalam.DATA_IZIN,dataIzin)
                }
                startActivity(intent);
            }
        })
    }
    fun loadData() {
        progressBarIzin.visibility = View.VISIBLE
        RetrofitInstance.instanceRetrofit.getIzinBermalam("Bearer ${sharedPref.getTokenBearer()}",sharedPref.getDimId().toLong())
            .enqueue(object : Callback<ResponseIzinBermalam>{
                override fun onFailure(call: Call<ResponseIzinBermalam>, t: Throwable) {
                    Toast.makeText(activity,t.message,Toast.LENGTH_SHORT).show()
                }

                override fun onResponse(
                    call: Call<ResponseIzinBermalam>,
                    response: Response<ResponseIzinBermalam>
                ) {
                    var list = response.body()
                    Log.d("Izin Bermalam",sharedPref.getDimId().toString())
                    list?.toString()?.let { Log.d("Isi data", it) }
                    if(list?.data == null){
                        alertData.visibility = View.VISIBLE
                        rv.visibility = View.GONE
                    }else{
                        alertData.visibility = View.GONE
                        rv.visibility = View.VISIBLE
                        ibAdapter.setData(list?.data)
                    }
                    progressBarIzin.visibility = View.GONE
                }
            })
    }

    override fun onClick(v: View?) {
        when(v!!.id){
            R.id.btn_request->{
                navController!!.navigate(R.id.action_nav_ib_to_requestIzinBermalamActivity)
            }
        }
    }
}