package ta1.cis.fragment

import android.os.Bundle
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.view.size
import androidx.fragment.app.FragmentManager
import androidx.viewpager2.widget.ViewPager2
import com.google.android.material.tabs.TabLayout
import com.google.android.material.tabs.TabLayoutMediator
import ta1.cis.R
import ta1.cis.adapter.ViewPagerAdapter


class DataDiriFragment : Fragment() {

    private lateinit var tabLayout :TabLayout
    private lateinit var viewPager2:ViewPager2
    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_data_diri, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {

        tabLayout = view.findViewById(R.id.tab_layout)
        viewPager2 = view.findViewById<ViewPager2>(R.id.view_pager2)
        val adapter=ViewPagerAdapter(childFragmentManager,lifecycle);
        viewPager2.adapter = adapter
        initTab()
        super.onViewCreated(view, savedInstanceState)
    }


    fun initTab(){
        TabLayoutMediator(tabLayout, viewPager2) { tab, position ->
            when(position){
                0->{
                    tab.text="Data Akademis"
                }
                1->{
                    tab.text="Data Pribadi"
                }
                2->{
                    tab.text = "Data Orangtua"
                }
                3->{
                    tab.text = "Asal Sekolah"
                }
                4->{
                    tab.text = "Keasramaan"
                }
                5->{
                    tab.text = "Nilai Perilaku"
                }
                6->{
                    tab.text = "Hasil Studi"
                }
            }
        }.attach()
    }
}