package ta1.cis.fragment

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.util.Log
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import android.widget.Toast
import androidx.navigation.Navigation
import androidx.recyclerview.widget.ConcatAdapter
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import kotlinx.android.synthetic.main.fragment_beranda.*
import kotlinx.android.synthetic.main.fragment_i_b.*
import kotlinx.android.synthetic.main.fragment_pengumuman.*
import kotlinx.android.synthetic.main.fragment_pengumuman.recyclerViewPengumuman
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import model.response.Pengumuman
import model.response.ResponsePengumuman
import retrofit2.*
import ta1.cis.R
import ta1.cis.activity.DetailIzinBermalam
import ta1.cis.adapter.IzinBermalamAdapter
import ta1.cis.adapter.PengumumanAdapter
import ta1.cis.adapter.SingleJadwalAdapter
import ta1.cis.api.RetrofitInstance
import ta1.cis.helper.SharedPref
import ta1.cis.model.response.DataIzin
import ta1.cis.model.response.ResponseIzinBermalam
import java.text.SimpleDateFormat
import java.util.*

class BerandaFragment : Fragment() {

    private lateinit var rv: RecyclerView
    private var list = ArrayList<DataIzin>()
    private lateinit var sharedPref: SharedPref
    lateinit var ibAdapter : IzinBermalamAdapter
    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        val view = inflater.inflate(R.layout.fragment_beranda, container, false)
        sharedPref = SharedPref(activity as Context)

        return view
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        rv = view.findViewById(R.id.recyclerViewPengumumanBeranda)
        var txt = view.findViewById<TextView>(R.id.dateToday)
        txt.text = SimpleDateFormat("EEEE,d MMM yyyy", Locale.getDefault()).format(Date())
    }
    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)

        refreshlayoutberanda.setOnRefreshListener {
            fetchPengumuman()
            fetchSingleJadwal()
        }
        fetchPengumuman()
        fetchSingleJadwal()
    }


    private fun fetchSingleJadwal(){
        refreshlayoutberanda.isRefreshing = true
        GlobalScope.launch(Dispatchers.IO) {
            val response = RetrofitInstance.instanceRetrofit.getJadwalToday("Bearer ${sharedPref.getTokenBearer()}").awaitResponse()
            if(response.isSuccessful){
                withContext(Dispatchers.Main){
                    val data = response.body()?.data
                    if(data != null){
                        rv_singleJadwal.layoutManager  = LinearLayoutManager(context,LinearLayoutManager.VERTICAL,false)
                        rv_singleJadwal.adapter = SingleJadwalAdapter(data)
                    }else{
                        descJadwal.text = "Jadwal Tidak ada Hari ini"
                        rv_singleJadwal.visibility = View.GONE
                    }
                }
            }
        }
    }

    private fun fetchPengumuman(){
        refreshlayoutberanda.isRefreshing = true

        RetrofitInstance.instanceRetrofit.getPengumuman("Bearer ${sharedPref.getTokenBearer()}").enqueue(object : Callback<ResponsePengumuman>{
            override fun onResponse(
                call: Call<ResponsePengumuman>,
                response: Response<ResponsePengumuman>
            ) {
                val pengumuman = response.body()
                refreshlayoutberanda.isRefreshing = false
                Log.d("Pengumuman",pengumuman.toString())
                pengumuman?.let {
                    var mypengumuman = it.data

                    showPengumuman(mypengumuman)
                }
            }

            override fun onFailure(call: Call<ResponsePengumuman>, t: Throwable) {
                refreshlayoutberanda.isRefreshing = false
                Toast.makeText(activity, t.message, Toast.LENGTH_LONG).show()
            }

        })
    }
    private fun showPengumuman(mypengumuman: List<Pengumuman>){
        var adapterMyPengumuman = PengumumanAdapter(mypengumuman)

        var pengumumanAdapter = ConcatAdapter(adapterMyPengumuman)
        recyclerViewPengumumanBeranda.layoutManager = LinearLayoutManager(activity)
        recyclerViewPengumumanBeranda.adapter = adapterMyPengumuman

    }

}