package ta1.cis.api

import android.content.ContentResolver
import android.content.Context
import android.net.Uri
import android.webkit.MimeTypeMap
import java.io.File

class Constants{
    companion object{
        val URLFileOrImage = "https://apipuro.del.ac.id/v1/file/";
        val BASE_URL = "http://localhost:8000/api/"
        fun getMimeType(context: Context, uri: Uri): String? {

            //Check uri format to avoid null
            var extension: String? = if (uri.scheme == ContentResolver.SCHEME_CONTENT) {
                //If scheme is a content
                val mime = MimeTypeMap.getSingleton()
                mime.getExtensionFromMimeType(context.contentResolver.getType(uri))
            } else {
                //If scheme is a File
                //This will replace white spaces with %20 and also other special characters. This will avoid returning null values on file name with spaces and special characters.
                MimeTypeMap.getFileExtensionFromUrl(Uri.fromFile(File(uri.path)).toString())
            }
            return extension
        }
    }
}