package ta1.cis.api

import com.google.gson.annotations.SerializedName
import model.response.*
import ta1.cis.model.response.*
import okhttp3.ResponseBody
import retrofit2.Call
import retrofit2.Response
import retrofit2.http.*
import ta1.cis.model.request.*
import ta1.cis.model.response.*

interface ApiService {
    @Headers("Content-Type: application/json")
    @POST("login")
    fun login(@Body userRequest: LoginRequest):Call<ResponseModel>

    @GET("dim")
    fun getDataPribadi(@Header("Authorization") token: String):Call<ResponseDataPribadi>

    @PUT("updateDim")
    fun updateDataPribadi(@Header("Authorization") token: String,
                          @Body editPribadi: RequestEditPribadi) : Call<ResponseEditPribadi>

    @GET("orangtua")
    fun getDataOrangtua(@Header("Authorization") token: String):Call<ResponseDataOrangtua>

    @PUT("updateOrangtua")
    fun updateDataOrangtua(@Header("Authorization") token: String, @Body editOrangtua: EditDataOrtu):Call<ResponseDataOrangtua>

    @GET("akademis")
    fun getDataAkademis(@Header("Authorization") token: String):Call<ResponseDataAkademis>

    @GET("sekolah")
    fun getDataSekolah(@Header("Authorization") token: String):Call<ResponseDataSekolah>

    @FormUrlEncoded
    @PUT("updateDataSekolah")
    fun updateDataSekolah(@Header("Authorization") token: String,
                          @Field("no_ijazah_sma") noIjazah: String,
                          @Field("nama_sma") namaSma:String?):Call<ResponseEditSekolah>

    @GET("dataAsrama")
    fun getDataAsrama(@Header("Authorization") token : String) : Call<ResponseDataAsrama>

    @GET("izinBermalam/{userId}")
    fun getIzinBermalam(@Header("Authorization")token : String, @Path("userId") userId : Long):Call<ResponseIzinBermalam>

    @Headers("Content-Type: application/json")
    @POST("izinBermalam/{userId}")
    fun saveIzinBermalam(@Header("Authorization") token : String,
                         @Path("userId") userId : Long,
                         @Body ibRequest: IBRequest
    ) : Call<ResponseSaveIB>

    @Headers("Content-Type: application/json")
    @GET("getIzin/{userId}/{izinId}")
    fun getDetailIzinBermalam(@Header("Authorization") token : String,
                              @Path("userId")userId:Long,
                              @Path("izinId")izinId : Long):Call<ResponseDetailIzinBermalam>

    @Headers("Content-Type: application/json")

    @GET("paket")
    fun getPaket(@Header("Authorization") token: String):Call<ResponsePaket>

    @GET("paket/{paketId}")
    fun getDetailPaket(@Header("Authorization") token: String,
                       @Path("paketId")paketId: String):Call<ResponseDetailPaket>

    @GET("pengumuman")
    fun getPengumuman(@Header("Authorization") token: String):Call<ResponsePengumuman>

    @GET("pengumuman/{pengumumanId}")
    fun getDetailPengumuman(@Header("Authorization") token: String, @Path("pengumumanId") pengumumanId: String):Call<ResponseDetailPengumuman>

    @GET("kuesioner")
    fun getKuesioner():Call<ResponseKuesioner>

    @GET("pertanyaan/{kuesionerId}")
    fun getPertanyaanKuesioner(
        @Header("Authorization") token: String,
        @Path("kuesionerId")kuesionerId: Long
    ): Call<ResponsePertanyaan>

    @FormUrlEncoded
    @PUT("batalIb")
    fun cancelIzinBermalam(
        @Field("idIzin") idIzin: Int?,
        @Header("Authorization")token: String
    ):Call<Unit>

    @PUT("editIb/{izinId}/{userId}")
    fun editIzinBermalam(
        @Path("izinId") izinId: Long,
        @Path("userId") userId: Long,
        @Body data:IBRequest,
        @Header("Authorization")token:String
    ):Call<Unit>

    @GET("izinKeluar/{dimId}")
    fun getIzinKeluar(
        @Path("dimId") dimId: Long,
        @Header("Authorization") bearer: String
    ):Call<ResponseIzinKeluar>

    @GET("izinKeluar/{id}/{izinId}")
    fun getDetailIzinKeluar(
        @Path("id") id: Long,
        @Path("izinId") dimId: Long,
        @Header("Authorization") bearer: String
    ):Call<ResponseDetailIzinKeluar>

    @POST("izinKeluar/{dimId}")
    fun saveIK(
        @Path("dimId") dimId: Long,
        @Body request: IKRequest,
        @Header("Authorization") bearer: String
    ):Call<Any>

    @PUT("izinKeluar/{izinId}/{id}")
    fun editIk(
        @Path("izinId")izinId: Long,
        @Path("id")id: Long,
        @Body data:IKRequest,
        @Header("Authorization")bearer: String
    ):Call<Any>

    @FormUrlEncoded
    @PUT("izinKeluar")
    fun cancelIk(
        @Field("idIzin") idIzin:Long,
        @Header("Authorization") bearer: String
    ):Call<Any>

    @GET("kurikulum/{tahun}/{prodi}")
    fun getMatkulBasedOnYearAndCollege(
        @Path("tahun") tahun: String,
        @Path("prodi") prodi: Int,
        @Header("Authorization") bearer: String
    ):Call<ResponsePerkuliahan>

    @GET("perkuliahan/{kuliahId}")
    fun getMateriKuliah(
        @Path("kuliahId") kuliahId: String?,
        @Header("Authorization") bearer: String,
        @Query("tahun") tahun: String? = null
    ):Call<ResponseMateriKul>

    @GET("fileMateri/{materiId}")
    fun getFileMateri(
        @Path("materiId") materiId: String,
        @Header("Authorization") bearer: String
    ):Call<ResponseFileMateri>

    @GET("praktikum/{kuliahId}")
    fun getPraktikum(
        @Path("kuliahId") kuliahId: String?,
        @Header("Authorization") bearer: String
    ):Call<ResponsePraktikum>

    @Headers("Content-Type: application/json")
    @POST("isiKuesioner")
    fun sendKuesionerAnsware(
        @Header("Authorization") bearer: String,
        @Body kuisionerReq: KuisionerAnsware
    ) : Call<ResponseIsiPertanyaan>

    @GET("jadwal")
    fun getAllJadwal(
        @Header("Authorization")bearer: String
    ):Call<ResponseJadwal>

    @GET("jadwalToday")
    fun getJadwalToday(
        @Header("Authorization") bearer:String
    ):Call<ResponseSingleJadwal>
}