package ta1.cis.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import ta1.cis.R
import ta1.cis.model.response.PraktikumItem

class PraktikumHeaderAdapter(val context: Context?, val listPraktikum: List<PraktikumItem>) : RecyclerView.Adapter<PraktikumHeaderAdapter.Holder>() {

    private val recyclePool = RecyclerView.RecycledViewPool()

    class Holder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val praktikum = itemView.findViewById<TextView>(R.id.modulPrak)
        val recyclePrak = itemView.findViewById<RecyclerView>(R.id.list_praktikum)
    }

    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int
    ): PraktikumHeaderAdapter.Holder {
        val view = LayoutInflater.from(context).inflate(R.layout.praktikum_header,parent,false)
        return Holder(view)
    }

    override fun onBindViewHolder(holder: PraktikumHeaderAdapter.Holder, position: Int) {
        var data = listPraktikum[position]
        holder.praktikum.text = "Modul Week ${data.mingguKe}"
        var childLinear = LinearLayoutManager(holder.itemView.context,LinearLayoutManager.VERTICAL,false)
        holder.recyclePrak.apply {
            layoutManager = childLinear
            adapter = PraktikumFooterAdapter(context,data.materi)
            setRecycledViewPool(recyclePool)

        }
    }

    override fun getItemCount(): Int = listPraktikum.size
}