package ta1.cis.adapter

import android.content.Context
import android.content.Intent
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.cardview.widget.CardView
import androidx.recyclerview.widget.RecyclerView
import ta1.cis.R
import ta1.cis.activity.DetailPraktikum
import ta1.cis.activity.PraktikumDetail
import ta1.cis.model.response.Item

class PraktikumFooterAdapter(var context: Context, var listPraktikum: List<Item>?) : RecyclerView.Adapter<PraktikumFooterAdapter.Holder>() {

    class Holder(itemView: View): RecyclerView.ViewHolder(itemView) {
        val sesi = itemView.findViewById<TextView>(R.id.sesi_praktikum)
        val materiPraktikum = itemView.findViewById<TextView>(R.id.judul_praktikum)
        val tujuan = itemView.findViewById<TextView>(R.id.tujuan_praktikum)
        val tanggal = itemView.findViewById<TextView>(R.id.tanggal_praktikum)
        val cardPraktikum = itemView.findViewById<CardView>(R.id.cardPraktikum)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): Holder {
        val view = LayoutInflater.from(context).inflate(R.layout.praktikum_footer,parent,false)
        return Holder(view)
    }

    override fun onBindViewHolder(holder: Holder, position: Int) {
        var data = listPraktikum?.get(position)
        holder.sesi.text = "Sesi :${data?.sesi}"
        holder.tujuan.text = "Tujuan : ${data?.tujuan}" ?: ""
        holder.materiPraktikum.text = data?.topik
        holder.tanggal.text = data?.tanggalSesi
        holder.cardPraktikum.setOnClickListener {
            val intent = Intent(context, DetailPraktikum::class.java).apply {
                putExtra(DetailPraktikum.DATA_PRAKTIKUM,data)
            }
            it.context.startActivity(intent)
        }
    }

    override fun getItemCount(): Int = listPraktikum!!.size
}
