package ta1.cis.adapter

import android.content.Context
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import android.widget.TableLayout
import android.widget.TableRow
import android.widget.TextView
import androidx.core.view.marginLeft
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import kotlinx.android.synthetic.main.header_semester.view.*
import org.w3c.dom.Text
import ta1.cis.R
import ta1.cis.model.response.HeaderItem

class PerkuliahanAdapter(val context: Context,val array: List<HeaderItem>) : RecyclerView.Adapter<PerkuliahanAdapter.PerkuliahanHolder>() {

    private val viewPool = RecyclerView.RecycledViewPool()

    class PerkuliahanHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val keteranganSemester = itemView.findViewById<TextView>(R.id.Keterangansemester)
        val recyclerView = itemView.findViewById<RecyclerView>(R.id.listMatkul)
    }

    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int
    ): PerkuliahanAdapter.PerkuliahanHolder {
        val view = LayoutInflater.from(context).inflate(R.layout.header_semester,parent,false)
        return PerkuliahanHolder(view)
    }

    override fun onBindViewHolder(holder: PerkuliahanAdapter.PerkuliahanHolder, position: Int){
        val parent = array[position];
        holder.keteranganSemester.text = "Semester ${parent.semester}"
        val childLayout = LinearLayoutManager(holder.itemView.context,LinearLayoutManager.VERTICAL,false)
        holder.recyclerView.apply {
            layoutManager = childLayout
            adapter = ChildPerkuliahanAdapter(context,parent.matakuliah)
            setRecycledViewPool(viewPool)
        }

    }

    override fun getItemCount(): Int = array.size
}