package ta1.cis.adapter

import android.content.Intent
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import kotlinx.android.synthetic.main.pengumuman_layout.view.*
import model.response.Pengumuman
import ta1.cis.R
import ta1.cis.activity.DetailPengumumanActivity
import ta1.cis.adapter.PengumumanAdapter.PengumumanViewHolder

class PengumumanAdapter(val pengumumans: List<Pengumuman>) : RecyclerView.Adapter<PengumumanViewHolder>() {
    


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): PengumumanViewHolder {
        return PengumumanViewHolder(
            LayoutInflater.from(parent.context)
                .inflate(R.layout.pengumuman_layout, parent, false)
        )
    }

    override fun onBindViewHolder(holder: PengumumanViewHolder, position: Int) {

        val pengumuman = pengumumans[position]
        holder.bind(pengumuman)
        holder.view.setOnClickListener {
            var intent = Intent(it.context,DetailPengumumanActivity::class.java).apply {
                putExtra(DetailPengumumanActivity.ID_PENGUMUMAN,pengumuman.id);
            }
            it.context.startActivity(intent)
        }
    }

    override fun getItemCount() = pengumumans.size

    public final inner class PengumumanViewHolder(val view: View) :RecyclerView.ViewHolder(view){
        fun bind(pengumuman: Pengumuman){
            view.judulPengumuman.text = pengumuman.judul
            view.tglpembuatan.text = pengumuman.pembuatan
            view.tglkedaluarsa.text = pengumuman.kadaluarsa

        }
    }
}