package ta1.cis.adapter

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import android.widget.Toast
import androidx.recyclerview.widget.RecyclerView
import kotlinx.android.synthetic.main.paket_layout.view.*
import model.response.DetailPaket
import model.response.Paket
import model.response.ResponsePaket
import ta1.cis.R
import ta1.cis.activity.DetailPaketActivity
import ta1.cis.model.response.DataIzin

class PaketAdapter(val pakets: List<Paket>) : RecyclerView.Adapter<PaketAdapter.PaketViewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): PaketViewHolder {
        return PaketViewHolder (
            LayoutInflater.from(parent.context)
                .inflate(R.layout.paket_layout, parent, false)
                )
    }
    override fun getItemCount() = pakets.size

    override fun onBindViewHolder(holder: PaketViewHolder, position: Int) {
        val paket = pakets[position]
        holder.bind(paket)
        holder.view.setOnClickListener {
//            Toast.makeText(it.context,paket.toString(),Toast.LENGTH_SHORT).show()
            val intent = Intent(it.context,DetailPaketActivity::class.java).apply {
                putExtra(DetailPaketActivity.DATA_PAKET,paket)
            }
            it.context.startActivity(intent)
        }
    }

    inner class PaketViewHolder(val view: View) : RecyclerView.ViewHolder(view){
        fun bind(paket: Paket){
            view.TagPaket.text = paket.tag
            view.namapenerima.text = paket.namaPenerima ?: "-";
            view.statusPaket.text = paket.status
        }
    }

}