package ta1.cis.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import ta1.cis.R
import ta1.cis.model.response.ListMateri

class MateriHeader(val context: Context?, val materiItemList: List<ListMateri?>?) : RecyclerView.Adapter<MateriHeader.Holder>() {
    private val recyleViewPool = RecyclerView.RecycledViewPool()
    class Holder(itemView: View) : RecyclerView.ViewHolder(itemView){
        val mingguKe = itemView.findViewById<TextView>(R.id.modul)
        val recycleMateri = itemView.findViewById<RecyclerView>(R.id.list_materi)
    }
    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): MateriHeader.Holder {
        val view = LayoutInflater.from(context).inflate(R.layout.materi_header,parent,false);
        return Holder(view)
    }

    override fun onBindViewHolder(holder: MateriHeader.Holder, position: Int) {
        val parent = materiItemList?.get(position)!!
        holder.mingguKe.text = "Modul Week ${parent.mingguKe}"
        val childLinear = LinearLayoutManager(holder.itemView.context,LinearLayoutManager.VERTICAL,false)
        holder.recycleMateri.apply {
            layoutManager = childLinear
            adapter = MateriFooterAdapter(context,parent.materi)
            setRecycledViewPool(recyleViewPool)
        }
    }

    override fun getItemCount(): Int = materiItemList?.size!!
}