package ta1.cis.adapter

import android.content.Context
import android.content.Intent
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import android.widget.Toast
import androidx.cardview.widget.CardView
import androidx.recyclerview.widget.RecyclerView
import ta1.cis.R
import ta1.cis.activity.DetailMateriActivity
import ta1.cis.model.response.MateriItem

class MateriFooterAdapter(val context: Context, val materiItem: List<MateriItem?>?) : RecyclerView.Adapter<MateriFooterAdapter.Holder>() {

    class Holder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val sesi = itemView.findViewById<TextView>(R.id.sesi_materi)
        val judulMateri = itemView.findViewById<TextView>(R.id.judul_materi)
        val tanggalView = itemView.findViewById<TextView>(R.id.tanggal_materi)
        val cardView = itemView.findViewById<CardView>(R.id.cardMatkul)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): MateriFooterAdapter.Holder {
        val view = LayoutInflater.from(context).inflate(R.layout.materi_footer, parent, false)
        return Holder(view)
    }

    override fun onBindViewHolder(holder: MateriFooterAdapter.Holder, position: Int) {
        val data = materiItem?.get(position)!!
        holder.sesi.text = "Sesi ${data.sesi}"
        holder.judulMateri.text = data.judul
        holder.tanggalView.text = data.tglView
        holder.cardView.setOnClickListener {
            val intent = Intent(context,DetailMateriActivity::class.java).apply {
                putExtra(DetailMateriActivity.DETAIL_MATAKULIAH, data)
            }
            it.context.startActivity(intent);
        }
    }

    override fun getItemCount(): Int = materiItem?.size!!
}