package ta1.cis.adapter

import android.content.Intent
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import kotlinx.android.synthetic.main.kuesioner_layout.view.*
import ta1.cis.R
import ta1.cis.activity.IsiKuesionerActivity
import ta1.cis.model.response.DataKuesioner

class KuesionerAdapter(private val kuesioners: List<DataKuesioner?>?) : RecyclerView.Adapter<KuesionerAdapter.KuesionerViewHolder>(){

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): KuesionerViewHolder {
        return KuesionerViewHolder (
            LayoutInflater.from(parent.context).inflate(R.layout.kuesioner_layout, parent, false)
                )
    }

    override fun getItemCount() = kuesioners!!.size

    override fun onBindViewHolder(holder: KuesionerAdapter.KuesionerViewHolder, position: Int) {
        val kuesioner = kuesioners?.get(position)
        if (kuesioner != null) {
            holder.bind(kuesioner)
        }
        holder.view.setOnClickListener {
            val intent = Intent(it.context, IsiKuesionerActivity::class.java).apply {
                putExtra(IsiKuesionerActivity.DATA_KUESIONER, kuesioner)
            }
            it.context.startActivity(intent)
        }
    }

    inner class KuesionerViewHolder(val view: View) : RecyclerView.ViewHolder(view){
        fun bind(kuesioner: DataKuesioner){
            view.judul_kuesioner.text = kuesioner.nama
            view.TA.text = kuesioner.ta
            view.semTA.text = kuesioner.sem
            view.kategori_kuesioner.text = kuesioner.kodeMk
        }
    }
}