package ta1.cis.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import ta1.cis.R
import ta1.cis.model.response.Jadwal

class JadwalHeaderAdapter(var context: Context?,var list: List<Jadwal>?) : RecyclerView.Adapter<JadwalHeaderAdapter.JadwalVH>() {
    private val recyleViewPool = RecyclerView.RecycledViewPool()
    class JadwalVH(itemView: View): RecyclerView.ViewHolder(itemView){
        val hari = itemView.findViewById<TextView>(R.id.day)
        val rv_footer = itemView.findViewById<RecyclerView>(R.id.rv_jadwalFooter)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): JadwalHeaderAdapter.JadwalVH {
        val view = LayoutInflater.from(context).inflate(R.layout.jadwal_layout,parent,false)
        return JadwalVH(view)
    }

    override fun onBindViewHolder(holder: JadwalHeaderAdapter.JadwalVH, position: Int) {
        var data = list?.get(position)
        holder.hari.text = data?.hari
        var childLayoutManager = LinearLayoutManager(holder.itemView.context,LinearLayoutManager.VERTICAL,false);
        holder.rv_footer.apply {
            layoutManager = childLayoutManager
            adapter = JadwalFooterAdapter(holder.itemView.context,data?.matkul)
            setRecycledViewPool(recyleViewPool)
        }
    }

    override fun getItemCount(): Int = list?.size!!
}