package ta1.cis.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import kotlinx.android.synthetic.main.jadwal_footer.view.*
import ta1.cis.R
import ta1.cis.model.response.MatkulJadwal

class JadwalFooterAdapter(var context: Context, var listMatkul: List<MatkulJadwal>?) : RecyclerView.Adapter<JadwalFooterAdapter.ViewHolder>() {

    class ViewHolder(itemView:View) : RecyclerView.ViewHolder(itemView){
        val jam = itemView.findViewById<TextView>(R.id.jam)
        val matkul = itemView.findViewById<TextView>(R.id.matkul)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val view = LayoutInflater.from(context).inflate(R.layout.jadwal_footer,parent,false)
        return ViewHolder(view)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        val data = listMatkul?.get(position)
        holder.itemView.jam.text = "${data?.mulaiMatkul} - ${data?.akhirMatkul}"
        holder.itemView.matkul.text = data?.namaMatkul
    }

    override fun getItemCount(): Int = listMatkul?.size!!
}