package ta1.cis.adapter

import android.graphics.Color
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.cardview.widget.CardView
import androidx.recyclerview.widget.RecyclerView
import org.w3c.dom.Text
import ta1.cis.R
import ta1.cis.model.response.DataIzin
import ta1.cis.model.response.DataIzinKeluar

class IzinKeluarAdapter(var izinKeluars : ArrayList<DataIzinKeluar>) :
    RecyclerView.Adapter<IzinKeluarAdapter.ViewHolder>() {

    private lateinit var onItemCallBack: IzinKeluarAdapter.OnItemCallBack;

    fun setOnItemCallback(onItemCallBack: IzinKeluarAdapter.OnItemCallBack){
        this.onItemCallBack = onItemCallBack
    }

    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int
    ): IzinKeluarAdapter.ViewHolder {
        val view:View = LayoutInflater.from(parent.context).inflate(R.layout.item_izin_keluar,parent,false);
        return IzinKeluarAdapter.ViewHolder(view)
    }

    class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var noUrut = itemView.findViewById<TextView>(R.id.numberIk)
        var keperluan = itemView.findViewById<TextView>(R.id.keperluanIkAll)
        var tglBerangkat = itemView.findViewById<TextView>(R.id.tglBerangaktIk)
        var tglKembali = itemView.findViewById<TextView>(R.id.tglKembaliIk)
        var cardView = itemView.findViewById<CardView>(R.id.card_ik)
        fun bind(dataIzinKeluar: DataIzinKeluar, position: Int){
            if(dataIzinKeluar.statusDosen == 1){
                if(dataIzinKeluar.statusKeasramaan == 1){
                    if(dataIzinKeluar.statusDosen == 1){
                        cardView.setCardBackgroundColor((Color.parseColor("#bbdefb")))
                    }
                }
            }else if(dataIzinKeluar.statusDosen == 2){
                cardView.setCardBackgroundColor(Color.parseColor("#c8e6c9"))
            }else if(dataIzinKeluar.statusDosen == 3){
                cardView.setCardBackgroundColor((Color.parseColor("#ffffe5")))
            }else if(dataIzinKeluar.statusDosen == 4){
                cardView.setCardBackgroundColor((Color.parseColor("#ffebee")))
            }
            noUrut.text = (position+1).toString()
            keperluan.text = dataIzinKeluar.keperluanIk
            tglBerangkat.text = dataIzinKeluar.rencanaBerangkat
            tglKembali.text = dataIzinKeluar.rencanaKembali
        }
    }

    override fun onBindViewHolder(holder: IzinKeluarAdapter.ViewHolder, position: Int) {
        var izinKeluar = izinKeluars.get(position)
        holder.bind(izinKeluar,position)
        holder.itemView.setOnClickListener {
            onItemCallBack.onItemClicked(izinKeluar)
        }
    }

    override fun getItemCount(): Int = izinKeluars.size
    fun setData(data : List<DataIzinKeluar>){
        izinKeluars.clear()
        izinKeluars.addAll(data)
        notifyDataSetChanged()
    }
    interface OnItemCallBack{
        fun onItemClicked(dataIzin: DataIzinKeluar)
    }
}