package ta1.cis.adapter

import android.graphics.Color
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.cardview.widget.CardView
import androidx.recyclerview.widget.RecyclerView
import kotlinx.android.synthetic.main.ib_layout.view.*
import org.w3c.dom.Text
import ta1.cis.model.response.DataIzin
import ta1.cis.R

class IzinBermalamAdapter(private val listIzinBermalam : ArrayList<DataIzin>) : RecyclerView.Adapter<IzinBermalamAdapter.IzinBermalamVM>(){
    private lateinit var onItemCallBack: OnItemCallBack;

    fun setOnItemCallback(onItemCallBack: OnItemCallBack){
        this.onItemCallBack = onItemCallBack
    }
    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int
    ): IzinBermalamAdapter.IzinBermalamVM {
        val view:View = LayoutInflater.from(parent.context).inflate(R.layout.ib_layout,parent,false);
        return IzinBermalamVM(view)
    }

    override fun getItemCount(): Int = listIzinBermalam.size

    override fun onBindViewHolder(holder: IzinBermalamAdapter.IzinBermalamVM, position: Int) {
        var data = listIzinBermalam[position]
        holder.bindContent(data,position)
        holder.itemView.setOnClickListener { onItemCallBack.onItemClicked(data) }

    }
    class IzinBermalamVM(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var number = itemView.findViewById<TextView>(R.id.number);
        var status = itemView.findViewById<CardView>(R.id.card_ib);
        var accept = itemView.findViewById<TextView>(R.id.disetujui)
        var purpose = itemView.findViewById<TextView>(R.id.keperluan)
        var destination = itemView.findViewById<TextView>(R.id.tujuan)

        fun bindContent(dataIzin: DataIzin, position : Int){
            number.text = (position + 1).toString()
            if(dataIzin.requestId == 1){
                status.setCardBackgroundColor((Color.parseColor("#bbdefb")))
            }else if(dataIzin.requestId == 2){
                status.setCardBackgroundColor(Color.parseColor("#c8e6c9"))
            }else if(dataIzin.requestId == 3){
                status.setCardBackgroundColor((Color.parseColor("#ffffe5")))
            }else if(dataIzin.requestId == 4){
                status.setCardBackgroundColor((Color.parseColor("#ffebee")))
            }
            if(dataIzin.disetujuiOleh == null){
                accept.text = "Disetujui Oleh : -"
            }else{
                accept.text = "Disetujui Oleh : ${dataIzin.disetujuiOleh}"
            }
            purpose.text = "Keperluan IB : ${dataIzin.keperluanIb}"
            destination.text = "Tujuan : ${dataIzin.tujuan}"
        }
    }
    fun setData(data : List<DataIzin>){
        listIzinBermalam.clear()
        listIzinBermalam.addAll(data)
        notifyDataSetChanged()
    }
    interface OnItemCallBack{
        fun onItemClicked(dataIzin: DataIzin)
    }
}