package ta1.cis.adapter

import android.content.Context
import android.os.Build
import android.text.Editable
import android.text.Html
import android.text.InputType
import android.text.TextWatcher
import android.text.method.LinkMovementMethod
import android.text.method.ScrollingMovementMethod
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.*
import androidx.core.view.marginTop
import androidx.core.view.setPadding
import androidx.core.view.updatePadding
import androidx.recyclerview.widget.RecyclerView
import kotlinx.android.synthetic.main.isikuesioner_layout.view.*
import ta1.cis.R
import ta1.cis.activity.IsiKuesionerActivity
import ta1.cis.model.response.Data
import ta1.cis.model.response.DataItem

class IsiKuisionerAdapter(
    val context: Context,
    var listPertanyaan:List<DataItem>,
    var answare: MutableList<String>
) : RecyclerView.Adapter<IsiKuisionerAdapter.Holder>() {
    class Holder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var tvNoQuestion = itemView.tvNoQuestion
        var tvQuestion = itemView.tvQuestion
        var tvKategori = itemView.tvKategori
        var linearOptions = itemView.rowChoice
        init {

        }
        fun bind(position:Int, context: Context, pertanyaan:DataItem, answare:String, total:Int) {
            if(pertanyaan.kategori.isNullOrEmpty()){
                tvKategori.visibility = View.GONE
            }else{
                tvKategori.visibility = View.VISIBLE
                tvKategori.text = pertanyaan.kategori.toString()
            }
            tvNoQuestion.text = (position + 1).toString() + "."
            tvQuestion.text =if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                Html.fromHtml(pertanyaan.pertanyaan, Html.FROM_HTML_MODE_COMPACT)
            } else {
                Html.fromHtml(pertanyaan.pertanyaan)
            }
            tvQuestion.movementMethod = LinkMovementMethod.getInstance()
            linearOptions.removeAllViews()
            if(pertanyaan.tipeOpsi.equals("R", true)){
                val radioGroup = RadioGroup(itemView.context.applicationContext)
                for (opsiItem in pertanyaan.opsi!!){
                    val radioButton = RadioButton(itemView.context.applicationContext)
                    if (opsiItem != null) {
                        radioButton.text = opsiItem.ketOpsi
                        radioGroup.addView(radioButton)
                        if(opsiItem.noOpsi.toString() == answare){
                            radioButton.isChecked = true
                        }
                        radioButton.setOnCheckedChangeListener { buttonView, isChecked ->
                            if(isChecked){
                                (itemView.context as IsiKuesionerActivity).setAnsware(position, opsiItem.noOpsi.toString())
                            }
                        }
                    }
                }
                linearOptions.addView(radioGroup)
            }
            else if(pertanyaan.tipeOpsi.equals("T", true)){
                val editText = EditText(itemView.context.applicationContext)
                Editable.Factory.getInstance().newEditable(answare).also { editText.text = it }
                ViewGroup.LayoutParams.MATCH_PARENT.also { editText.width = it }
                ViewGroup.LayoutParams.WRAP_CONTENT.also { editText.height = it }
                (InputType.TYPE_TEXT_VARIATION_LONG_MESSAGE or InputType.TYPE_TEXT_FLAG_IME_MULTI_LINE).also { editText.inputType = it }
                5.also { editText.minLines = it }
                Gravity.TOP.also { editText.gravity = it }
                false.also { editText.isSingleLine = it }
                editText.updatePadding(20, 30, 20,30)
                editText.setBackgroundResource(R.drawable.edit_text_bordered)


                editText.addTextChangedListener(object :TextWatcher{
                    override fun beforeTextChanged(
                        s: CharSequence?,
                        start: Int,
                        count: Int,
                        after: Int
                    ) {
                    }

                    override fun onTextChanged(
                        s: CharSequence?,
                        start: Int,
                        before: Int,
                        count: Int
                    ) {
                    }

                    override fun afterTextChanged(s: Editable?) {
                        (itemView.context as IsiKuesionerActivity).setAnsware(position, s.toString())
                    }

                })
                linearOptions.addView(editText)
            }
            else if(pertanyaan.tipeOpsi.equals("C", true)){
                var option = answare.split(",").toMutableList()
                for (opsiItem in pertanyaan.opsi!!){
                    val checkBox = CheckBox(itemView.context.applicationContext)
                    if (opsiItem != null) {
                        checkBox.text = opsiItem.ketOpsi
                        if(option.contains(opsiItem.noOpsi.toString())){
                            checkBox.isChecked = true
                        }
                        checkBox.setOnCheckedChangeListener{ buttonView, isChecked ->
                            if(isChecked){
                                if(!option.contains(opsiItem.noOpsi.toString())){
                                    option.add(opsiItem.noOpsi.toString())
                                }
                            }else{
                                option.remove(opsiItem.noOpsi.toString())
                            }
                            (itemView.context as IsiKuesionerActivity).setAnsware(position, option.joinToString(","))
                        }
                    }
                    linearOptions.addView(checkBox)
                }
            }

            if(total === (position + 1)){
                var button = Button(itemView.context.applicationContext)
                button.text = "Kirimkan hasil"
                var params= LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT)
                params.topMargin = 40
                button.layoutParams =params
                linearOptions.addView(button)
                button.setOnClickListener {
                    (itemView.context as IsiKuesionerActivity).sendAnsware(button)
                }
            }
        }

    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): Holder {
        val view = LayoutInflater.from(context).inflate(R.layout.isikuesioner_layout, parent, false)
        return Holder(view)
    }

    override fun onBindViewHolder(holder: Holder, position: Int) =
        holder.bind(position, context, listPertanyaan[position], answare[position], listPertanyaan.size)

    override fun getItemCount(): Int = listPertanyaan.size
}