package ta1.cis.adapter

import android.Manifest
import android.app.Activity
import android.app.DownloadManager
import android.content.Context
import android.content.pm.PackageManager
import android.net.Uri
import android.os.Environment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import android.widget.Toast
import androidx.cardview.widget.CardView
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat.getSystemService
import androidx.recyclerview.widget.RecyclerView
import ta1.cis.R
import ta1.cis.activity.DetailPengumumanActivity
import ta1.cis.api.Constants
import ta1.cis.model.response.DataFile

class DetailFileAdapter(val context: Context, val fileList: List<DataFile>?) : RecyclerView.Adapter<DetailFileAdapter.Holder>(){

    class Holder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val namaFile = itemView.findViewById<TextView>(R.id.namaFile)
        val kapasitasFile = itemView.findViewById<TextView>(R.id.size)
        val cardView = itemView.findViewById<CardView>(R.id.filemateri)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): DetailFileAdapter.Holder {
        val view = LayoutInflater.from(context).inflate(R.layout.file_layout,parent,false);
        return Holder(view)
    }

    override fun onBindViewHolder(holder: DetailFileAdapter.Holder, position: Int) {
        var data = fileList?.get(position)
        holder.namaFile.text = data?.namaFile
        holder.kapasitasFile.text = "Size : ${data?.keterangan}"
        holder.cardView.setOnClickListener {
            Toast.makeText(context,"File Sedang Di download",Toast.LENGTH_SHORT).show()
            downloadFile(data?.namaFile,data?.kodeFile)
        }
    }

    override fun getItemCount(): Int = fileList?.size ?: -1

    fun downloadFile(namaFile: String?, kodeFile: String?){
        if (ActivityCompat.checkSelfPermission(
                context,
                Manifest.permission.READ_EXTERNAL_STORAGE
            ) != PackageManager.PERMISSION_GRANTED
            || ActivityCompat.checkSelfPermission(
                context,
                Manifest.permission.WRITE_EXTERNAL_STORAGE
            ) != PackageManager.PERMISSION_GRANTED
        ) {

            // this will request for permission when user has not granted permission for the app
            ActivityCompat.requestPermissions(
                context as Activity,
                arrayOf(
                    Manifest.permission.READ_EXTERNAL_STORAGE,
                    Manifest.permission.WRITE_EXTERNAL_STORAGE
                ),
                1
            )
        } else {
            //Download Script
            val downloadManager = context.getSystemService(Context.DOWNLOAD_SERVICE) as DownloadManager
            val uri: Uri = Uri.parse(Constants.URLFileOrImage + "${kodeFile}")
            val request = DownloadManager.Request(uri)
            var mime = Constants.getMimeType(context,uri);
            request.setVisibleInDownloadsUi(true)
            request.setNotificationVisibility(DownloadManager.Request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED)
            request.setDestinationInExternalPublicDir(
                Environment.DIRECTORY_DOWNLOADS,
                namaFile
            )
            request.setDescription("Downloading")
            request.setAllowedOverMetered(true)
            request.setAllowedOverRoaming(true)
            request.setTitle("Download File ${namaFile}")
            request.setMimeType(mime)
            request.setNotificationVisibility(DownloadManager.Request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED)
            downloadManager.enqueue(request)
        }
    }
}