package ta1.cis.adapter

import android.content.Context
import android.content.Intent
import android.graphics.Paint
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import android.widget.Toast
import androidx.recyclerview.widget.RecyclerView
import ta1.cis.R
import ta1.cis.activity.MatakuliahActivity
import ta1.cis.model.response.MatakuliahItem

class ChildPerkuliahanAdapter(var context: Context, var listMatkul: List<MatakuliahItem?>?) : RecyclerView.Adapter<ChildPerkuliahanAdapter.Holder>() {

    class Holder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var sks = itemView.findViewById<TextView>(R.id.sks)
        var matkul = itemView.findViewById<TextView>(R.id.namaMatakuliah)
        var kodeMatkul = itemView.findViewById<TextView>(R.id.kodeMatakuliah)
    }

    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int
    ): ChildPerkuliahanAdapter.Holder {
        var view = LayoutInflater.from(parent.context).inflate(R.layout.list_matkul,parent,false)
        return Holder(view)
    }

    override fun onBindViewHolder(holder: ChildPerkuliahanAdapter.Holder, position: Int) {
        var matakuliah = listMatkul?.get(position)
        holder.sks.text = matakuliah?.sks
        holder.matkul.text = matakuliah?.namaMatakuliahInd
        holder.matkul.paintFlags = holder.matkul.paintFlags or Paint.UNDERLINE_TEXT_FLAG
        holder.kodeMatkul.text = matakuliah?.kodeMatakuliah
        holder.matkul.setOnClickListener {
            val intent = Intent(context,MatakuliahActivity::class.java).apply {
                putExtra(MatakuliahActivity.MATAKULIAH_ITEM,matakuliah)
            }
            it.context.startActivity(intent)
        }
    }

    override fun getItemCount(): Int = listMatkul?.size!!
}