package ta1.cis.activity

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.widget.TableLayout
import androidx.viewpager.widget.ViewPager
import androidx.viewpager2.widget.ViewPager2
import com.google.android.material.tabs.TabLayout
import com.google.android.material.tabs.TabLayoutMediator
import ta1.cis.R
import ta1.cis.adapter.MateriVPAdapter
import ta1.cis.fragment.MateriFragment
import ta1.cis.model.response.MatakuliahItem

class MatakuliahActivity : AppCompatActivity() {

    private lateinit var viewPager : ViewPager2
    private lateinit var tabLayout : TabLayout
    private lateinit var matakuliah: MatakuliahItem

    companion object{
        val MATAKULIAH_ITEM = "MATAKULIAH_ITEM"
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_matakuliah)
        viewPager = findViewById(R.id.vp_matkul)
        tabLayout = findViewById(R.id.tabLayoutmatkul)
        matakuliah = intent.getParcelableExtra(MATAKULIAH_ITEM)!!
        initVP()
    }

    private fun initVP() {
        val adapter = MateriVPAdapter(supportFragmentManager,lifecycle)
        viewPager.adapter = adapter
        initTab()

    }

    fun getKuliahId(): String? = matakuliah.idKuliah

    fun initTab(){
        TabLayoutMediator(tabLayout, viewPager) { tab, position ->
            when(position){
                0->{
                    tab.text="Materi Kuliah"
                }
                1->{
                    tab.text="Materi Praktikum"
                }
            }
        }.attach()
    }
}