package ta1.cis.activity
import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.util.Log
import android.view.Menu
import android.view.MenuInflater
import android.view.MenuItem
import androidx.appcompat.app.ActionBarDrawerToggle
import androidx.appcompat.widget.Toolbar
import ta1.cis.R
import androidx.navigation.Navigation
import androidx.navigation.ui.AppBarConfiguration
import androidx.navigation.ui.NavigationUI
import androidx.navigation.ui.setupActionBarWithNavController
import ta1.cis.helper.SharedPref
import kotlinx.android.synthetic.main.activity_home.*
import ta1.cis.service.NotificationService

class HomeActivity : AppCompatActivity() {
    private lateinit var sharedPref: SharedPref
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContentView(R.layout.activity_home)

        var toolbar = findViewById(R.id.toolbar) as Toolbar?
        sharedPref = SharedPref(this)
        supportActionBar?.setDisplayHomeAsUpEnabled(false)
        setSupportActionBar(toolbar)

        // Disini
        val navController = Navigation.findNavController(this, R.id.fragment_container)
        if(intent?.hasExtra("NotifType") == true){
            if(intent?.getStringExtra("NotifType").equals("IB")){
                navController.navigate(R.id.action_nav_beranda_to_nav_ib)
            }
        }

        val appConfiguration = AppBarConfiguration(setOf(R.id.nav_profile
            ,R.id.nav_beranda
            ,R.id.nav_perkuliahan,R.id.nav_jadwal
            ,R.id.nav_krs,R.id.nav_ib, R.id.nav_ik,R.id.nav_pengumuman,R.id.nav_paket,R.id.nav_kuesioner),drawer_layout);
        NavigationUI.setupWithNavController(nav_view, navController)
        setupActionBarWithNavController(navController,appConfiguration)

        val toggle = ActionBarDrawerToggle(this, drawer_layout, toolbar, R.string.navigation_drawer_open, R.string.navigation_drawer_close)
        drawer_layout.addDrawerListener(toggle)
        toggle.syncState()


    }

    override fun onCreateOptionsMenu(menu: Menu?): Boolean {
        val inflater : MenuInflater = menuInflater
        inflater.inflate(R.menu.support_menu,menu)

        return true
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        if(item.itemId == R.id.logout){
            sharedPref.clearAll()
            val intent =Intent(this@HomeActivity,LoginActivity::class.java);
            stopService(Intent(this@HomeActivity,NotificationService::class.java))
            startActivity(intent)
            finish()
        }
        return true
    }
}