package ta1.cis.activity

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.util.Log
import android.view.View
import android.widget.ArrayAdapter
import android.widget.EditText
import android.widget.Spinner
import android.widget.Toast
import kotlinx.android.synthetic.main.activity_edit_data_orangtua.*
import kotlinx.android.synthetic.main.activity_edit_pribadi.*
import kotlinx.coroutines.*
import retrofit2.awaitResponse
import ta1.cis.R
import ta1.cis.api.RetrofitInstance
import ta1.cis.fragment.tabitem.D_OrangTuaFragment
import ta1.cis.helper.SharedPref
import ta1.cis.model.request.EditDataOrtu


class EditDataOrangtuaActivity : AppCompatActivity(){

    private lateinit var sharedPref: SharedPref
    val penghasilanList = arrayOf<String>("Rentang Penghasilan","< 1.000.000", "2000000 - 3500000","5000000 - 10000000", ">10000000")

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_edit_data_orangtua)
        setSupportActionBar(topAppBarOrtu)
        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        sharedPref = SharedPref(this)
        val NamaAyah = intent.getStringExtra("Nama_Ayah")
        val EditNamaAyah: EditText = findViewById(R.id.etNamaAyah)
        EditNamaAyah.setText(NamaAyah)

        val NamaIbu = intent.getStringExtra("Nama_Ibu")
        val EditNamaIbu: EditText = findViewById(R.id.etNamaIbu)
        EditNamaIbu.setText(NamaIbu)

        val HpAyah = intent.getStringExtra("No_Hp_Ayah")
        val EditHpAyah: EditText = findViewById(R.id.etHpAyah)
        EditHpAyah.setText(HpAyah)

        val HpIbu = intent.getStringExtra("No_Hp_Ibu")
        val EditHpIbu: EditText = findViewById(R.id.etHpIbu)
        EditHpIbu.setText(HpIbu)

        val AlamatOrtu = intent.getStringExtra("Alamat_Ortu")
        val EditAlamatOrtu: EditText = findViewById(R.id.etAlamatOrtu)
        EditAlamatOrtu.setText(AlamatOrtu)

        val KetPekerjaanAyah = intent.getStringExtra("Keterangan_Pekerjaan_Ayah")
        val EditKetPekerjaanAyah: EditText = findViewById(R.id.ketPekerjaanAyah)
        EditKetPekerjaanAyah.setText(KetPekerjaanAyah)

        val PengPastiAyah = intent.getStringExtra("Penghasilan_Pasti_Ayah")
        val EditPengPastiAyah: EditText = findViewById(R.id.penghasilanpastiAyah)
        EditPengPastiAyah.setText(PengPastiAyah)

        val KetPekerjaanIbu = intent.getStringExtra("Keterangan_Pekerjaan_Ibu")
        val EditKetPekerjaanIbu: EditText = findViewById(R.id.ketPekerjaanIbu)
        EditKetPekerjaanIbu.setText(KetPekerjaanIbu)

        val PengPastiIbu = intent.getStringExtra("Penghasilan_Pasti_Ibu")
        val EditPengPastiIbu: EditText = findViewById(R.id.penghasilanpastiIbu)
        EditPengPastiIbu.setText(PengPastiIbu)

        val TotalPengOrtu = intent.getStringExtra("Total_Pendapatan_Ortu")
        val EditTotalPengOrtu: EditText = findViewById(R.id.etTotalpendapatan)
        EditTotalPengOrtu.setText(TotalPengOrtu)

        val JlhTanggungan = intent.getStringExtra("Jumlah_Tanggungan")
        val EditJlhTanggungan: EditText = findViewById(R.id.etJlhtanggungan)
        EditJlhTanggungan.setText(JlhTanggungan)

        val NamaWali = intent.getStringExtra("Nama_Wali")
        val EditNamaWali: EditText = findViewById(R.id.etnamaWali)
        EditNamaWali.setText(NamaWali)

        val AlamatWali = intent.getStringExtra("Alamat_Wali")
        val EditAlamatWali: EditText = findViewById(R.id.etalamatWali)
        EditAlamatWali.setText(AlamatWali)

        val KetKerjaWali = intent.getStringExtra("Keterangan_Pekerjaan_Wali")
        val EditKetKerjaWali: EditText = findViewById(R.id.etKetkerjaWali)
        EditKetKerjaWali.setText(KetKerjaWali)

        val PengPastiWali = intent.getStringExtra("Penghasilan_Pasti_Wali")
        val EditPengPastiWali: EditText = findViewById(R.id.etpenghasilanpastiWali)
        EditPengPastiWali.setText(PengPastiWali)


        val NoHpWali = intent.getStringExtra("No_Hp_Wali")
        val EditNoHpWali: EditText = findViewById(R.id.etHpWali)
        EditNoHpWali.setText(NoHpWali)

        val pekerjaanAyah = intent.getStringExtra("Pekerjaan_Ayah");
        createSpinnerPekerjaan(pekerjaanAyah,"ayah")
        val pekerjaanIbu = intent.getStringExtra("Pekerjaan_Ibu")
        createSpinnerPekerjaan(pekerjaanIbu,"ibu");
        val pekerjaanWalis = intent.getStringExtra("Pekerjaan_Wali")
        createSpinnerPekerjaan(pekerjaanWalis,"wali");
        val rentangPenghasilanAyah = intent.getStringExtra("Rentang_Penghasilan_Ayah");
        val rentangPenghasilanIbu = intent.getStringExtra("Rentang_Penghasilan_Ibu");
        val rentangPenghasilanWali = intent.getStringExtra("Rentang_Penghasilan_Wali");

        Log.d("GAIS",rentangPenghasilanWali.toString())
        createSpinnerPenghasilan(rentangPenghasilanAyah,"ayah")
        createSpinnerPenghasilan(rentangPenghasilanIbu,"ibu")
        createSpinnerPenghasilan(rentangPenghasilanWali,"wali")
        saveEditOrangtua.setOnClickListener {

            pb_orangtua.visibility = View.VISIBLE
            var pekerjaanIdIbu = getPekerjaan(spinner_kerjaIbu);
            var pekerjaanIdWali = getPekerjaan(pekerjaanWali)
            var pekerjaanIdAyah = getPekerjaan(spinner_kerjaAyah)
            var penghasilanIdAyah = getPenghasilan(spinner_rentpengAyah)
            var penghasilanIdIbu = getPenghasilan(spinner_rentpengIbu)
            var penghasilanIdWali = getPenghasilan(rentpenghasilanWali)
            Log.d("Penghasilan",penghasilanIdWali.toString())
            val data = EditDataOrtu(
                etNamaAyah.text.toString(),
                etNamaIbu.text.toString(),
                etAlamatOrtu.text.toString(),
                etHpAyah.text.toString(),
                etpenghasilanpastiWali.text.toString(),
                penghasilanpastiAyah.text.toString(),
                etHpWali.text.toString(),
                penghasilanpastiIbu.text.toString(),
                pekerjaanIdIbu,
                etnamaWali.text.toString(),
                pekerjaanIdWali,
                penghasilanIdAyah,
                etHpIbu.text.toString(),
                penghasilanIdIbu,
                etalamatWali.text.toString(),
                pekerjaanIdAyah,
                penghasilanIdWali,
                etKetkerjaWali.text.toString(),
                etTeleponWali.text.toString(),
                ketPekerjaanAyah.text.toString(),
                ketPekerjaanIbu.text.toString()
            )
            editDataOrangtua(data)
        }
        topAppBarOrtu.setNavigationOnClickListener {
            onBackPressed()
        }
    }

    private fun getPenghasilan(spinner: Spinner): Int? {
        return when(spinner.selectedItem.toString()){
            "< 1.000.000" -> 1
            "2000000 - 3500000" -> 2
            "5000000 - 10000000" -> 3
            "> 10000000" -> 4
            else -> null
        }
    }

    private fun editDataOrangtua(data:EditDataOrtu){
        GlobalScope.launch(Dispatchers.IO){
            val response = RetrofitInstance.instanceRetrofit.updateDataOrangtua("Bearer ${sharedPref.getTokenBearer()}",data).awaitResponse()
            if (response.isSuccessful){
                var pribadi = response.body()?.data
                Log.d("GAIS",pribadi.toString())
                withContext(Dispatchers.Main){
                    pb_orangtua.visibility = View.GONE
                    sharedPref.setStatusUpdate(2)
                    Toast.makeText(applicationContext,"Data sudah berhasil di update", Toast.LENGTH_LONG).show()
                    onBackPressed()
                }
            }
        }
    }

    fun createSpinnerPenghasilan(penghasilan:String?,type:String){
        val arrayAdapter = ArrayAdapter(this,android.R.layout.simple_spinner_item,penghasilanList)
        when(type){
            "ayah"->{
                spinner_rentpengAyah.adapter = arrayAdapter
                spinner_rentpengAyah.setSelection(getIndex(spinner_rentpengAyah,penghasilan))
            }
            "ibu"->{
                spinner_rentpengIbu.adapter = arrayAdapter
                spinner_rentpengIbu.setSelection(getIndex(spinner_rentpengIbu,penghasilan))
            }
            "wali"->{
                rentpenghasilanWali.adapter = arrayAdapter
                rentpenghasilanWali.setSelection(getIndex(rentpenghasilanWali,penghasilan))
            }
        }
    }

    fun createSpinnerPekerjaan(pekerjaan:String?,type:String){
        ArrayAdapter.createFromResource(
            this,
            R.array.pekerjaan_list,
            android.R.layout.simple_spinner_item
        ).also { adapter ->
            adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
            // Apply the adapter to the spinner
            if(type == "ayah"){
                spinner_kerjaAyah.adapter = adapter
                spinner_kerjaAyah.setSelection(getIndex(spinner_kerjaAyah,pekerjaan))
            }else if(type == "ibu"){
                spinner_kerjaIbu.adapter = adapter
                spinner_kerjaIbu.setSelection(getIndex(spinner_kerjaIbu,pekerjaan))
            }else{
                pekerjaanWali.adapter = adapter
                pekerjaanWali.setSelection(getIndex(pekerjaanWali,pekerjaan))
            }
        }
    }
    fun getPekerjaan(spinner: Spinner):Int?{
        when(spinner.selectedItem.toString()){
            "Pegawai Negeri Sipil"->{
                return 1
            }
            "Guru" -> {
                return 2
            }
            "Pejabat Pemerintah" -> {
                return 3
            }
            "TNI/Polri" -> {
                return 4
            }
            "Wiraswasta" -> {
                return 5
            }
            "Karyawan Swasta"->{
                return 6
            }
            "Petani" -> {
                return 7
            }
            "Lainnya" -> {
                return 8
            }
        }
        return null
    }
    private fun getIndex(spinner: Spinner, data: String?): Int {
        for (i in 0 until spinner.count){
            if(spinner.getItemAtPosition(i).toString().equals(data)){
                return i
            }
        }
        return 0
    }
}