package ta1.cis.activity

import android.os.Bundle
import android.util.Log
import android.view.View
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import com.google.gson.Gson
import kotlinx.android.synthetic.main.activity_detail_paket.*
import kotlinx.android.synthetic.main.activity_detail_paket.topAppBar
import kotlinx.android.synthetic.main.activity_request_izin_bermalam.*
import kotlinx.android.synthetic.main.paket_layout.*
import kotlinx.coroutines.*
import model.response.DataPaket
import model.response.DetailPaket
import model.response.Paket
import model.response.ResponseDetailPaket
import okhttp3.Dispatcher
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import retrofit2.awaitResponse
import ta1.cis.R
import ta1.cis.api.RetrofitInstance
import ta1.cis.helper.SharedPref

class DetailPaketActivity : AppCompatActivity() {
    private lateinit var idpaket: Paket
    private lateinit var sharedPref: SharedPref

    companion object{
        val DATA_PAKET : String = "DATA_PAKET"
        val TAG = "Detail Paket"
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_detail_paket)
        setSupportActionBar(topAppBar)

        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        sharedPref = SharedPref(this)
        idpaket = intent.getParcelableExtra<DataPaket>("DATA_PAKET") as Paket

        fetchDetailPaket()
        topAppBar.setNavigationOnClickListener{
            onBackPressed()
        }
    }

    private fun fetchDetailPaket(){
        GlobalScope.launch(Dispatchers.IO) {
            val response = RetrofitInstance.instanceRetrofit.getDetailPaket("Bearer ${sharedPref.getTokenBearer()}", idpaket.id).awaitResponse()
            if(response.isSuccessful){
                val data = response.body()!!

                withContext(Dispatchers.Main){
                    progressBar.visibility = View.GONE
                    data.data.forEach {
                        tagpaket.text = it.tag
                        pengirim.text = it.pengirim
                        wktu_kedatangan.text = it.waktuKedatangan
                        posisi_paket.text = it.posisiPaket
                        statuspaket.text = it.statusPaket
                        diambil.text = it.namaPenerima ?: "-"
                        wktu_ambil.text  = it.waktuDiambil ?: "-"
                        deskripsi_paket.text = it.deskripsi
                    }
                }

            }
        }
    }

    private fun showDetailPaket(detailpaket: DetailPaket){
        namapenerima.text = detailpaket.deskripsi
        Toast.makeText(this, detailpaket.deskripsi, Toast.LENGTH_LONG).show()
    }
}