package ta1.cis.activity

import android.os.Build
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.text.Html
import android.text.method.LinkMovementMethod
import android.util.Log
import android.widget.Toast
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import kotlinx.android.synthetic.main.activity_detail_materi.*
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import retrofit2.awaitResponse
import ta1.cis.R
import ta1.cis.adapter.DetailFileAdapter
import ta1.cis.api.RetrofitInstance
import ta1.cis.helper.SharedPref
import ta1.cis.model.response.MateriItem

class DetailMateriActivity : AppCompatActivity() {


    private lateinit var detailMateri: MateriItem
    private lateinit var sharedPref: SharedPref
    private lateinit var recyclerView: RecyclerView

    companion object{
        val DETAIL_MATAKULIAH = "DETAIL_MATAKULIAH"
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_detail_materi)
        setSupportActionBar(topAppBarDetailMatkul)
        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        detailMateri = intent.getParcelableExtra<MateriItem>(DETAIL_MATAKULIAH) as MateriItem
//        Log.d("DetailM",detailMateri.toString())
        sharedPref = SharedPref(this)
        recyclerView = findViewById(R.id.rv_file)
        setupFileRecycle()
    }

    private fun setupFileRecycle() {
        GlobalScope.launch(Dispatchers.IO) {
            val response = RetrofitInstance.instanceRetrofit.getFileMateri(detailMateri.materiId,"Bearer ${sharedPref.getTokenBearer()}").awaitResponse()
            if(response.body()?.status == 200){
                withContext(Dispatchers.Main){
                    val data = response?.body()?.data
                    judul_detail_materi.text = detailMateri.judul
                    tglSesi.text = "Tanggal Sesi ${detailMateri.tanggalSesi}"
                    isi.text = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                        Html.fromHtml(detailMateri.isi, Html.FROM_HTML_MODE_COMPACT)
                    } else {
                        Html.fromHtml(detailMateri.isi)
                    }
                    isi.movementMethod = LinkMovementMethod.getInstance()
                    mingguSesi.text = "Minggu ke / Sesi : ${detailMateri.mingguKe} / ${detailMateri.sesi}"
                    rv_file.layoutManager = LinearLayoutManager(this@DetailMateriActivity,LinearLayoutManager.VERTICAL,false)
                    rv_file.adapter = DetailFileAdapter(this@DetailMateriActivity,data)
                }
            }else{
                withContext(Dispatchers.Main){
                    Toast.makeText(this@DetailMateriActivity,"Ada masalah dengan Internet Anda",Toast.LENGTH_LONG).show()
                }
            }
        }
    }
}