package ta1.cis.activity

import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.util.Log
import android.view.View
import android.widget.Toast
import kotlinx.android.synthetic.main.activity_detail_izin_keluar.*
import kotlinx.android.synthetic.main.activity_edit_izin_bermalam.*
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import retrofit2.awaitResponse
import ta1.cis.R
import ta1.cis.api.RetrofitInstance
import ta1.cis.helper.SharedPref
import ta1.cis.model.response.DataIzinKeluar

class DetailIzinKeluar : AppCompatActivity() {

    private lateinit var sharedPref: SharedPref
    private lateinit var izinKeluar: DataIzinKeluar
    companion object{
        var DATA_IZIN_KELUAR  = "DATA_IZIN_KELUAR"
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_detail_izin_keluar)
        setSupportActionBar(topAppBarDetailIk)
        sharedPref = SharedPref(this)
        izinKeluar = intent.getParcelableExtra<DataIzinKeluar>(DATA_IZIN_KELUAR) as DataIzinKeluar
        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        fetchDetail()
        topAppBarDetailIk.setNavigationOnClickListener {
            onBackPressed()
        }
        editIzinKeluar.setOnClickListener {
            sendData()
        }
        cancelIzinKeluar.setOnClickListener {
            cancelIK()
        }
    }

    override fun onStart() {
        super.onStart()
        fetchDetail()
    }

    private fun sendData() {
        Intent(this,EditIzinKeluar::class.java).apply {
            putExtra(EditIzinKeluar.DATA_IZIN_KELUAR,izinKeluar)
        }.also {
            startActivity(it)
        }
    }

    private fun cancelIK(){
        pbDetailIk.visibility = View.VISIBLE
        GlobalScope.launch(Dispatchers.IO) {
            val response = RetrofitInstance.instanceRetrofit.cancelIk(izinKeluar.izinKeluarId!!.toLong(),"Bearer ${sharedPref.getTokenBearer()}").awaitResponse()
            if(response.isSuccessful){
                withContext(Dispatchers.Main){
                    pbDetailIk.visibility = View.GONE
                    Toast.makeText(baseContext,"IK Berhasil di batalkan",Toast.LENGTH_LONG).show()
                    onBackPressed()
                }
            }
        }
    }

    private fun  fetchDetail(){
        pbDetailIk.visibility = View.VISIBLE
        GlobalScope.launch(Dispatchers.IO) {
            val response = RetrofitInstance.instanceRetrofit.getDetailIzinKeluar(sharedPref.getDimId().toLong()
                ,izinKeluar.izinKeluarId!!.toLong(),"Bearer ${sharedPref.getTokenBearer()}").awaitResponse()
                if(response.isSuccessful){
                    withContext(Dispatchers.Main){
                    val data = response.body()?.data
                    pemohon.text = data?.pemohon
                    nimMahasiswa.text = data?.nimMahasiswa
                    keperluanIK.text = data?.keperluanIk
                    rencanaberangkat.text = data?.rencanaBerangkat
                    rencanakembali.text = data?.rencanaKembali
                    realisasiberangkat.text = data?.realisasiBerangkat ?: "-"
                    realisasikembali.text = data?.realisasiKembali ?: "-"
                    var statusDosen = data?.statusDosen
                    var statusBaak = data?.statusBaak
                    var statusKeasramaan = data?.statusKeasramaan
                    if(statusDosen == 3 || statusBaak == 3 || statusKeasramaan == 3){
                        if(statusDosen == 3){
                            status_request_dosen_wali.text = "Ditolak"
                            disetujuiwali.text = data?.namaDosen
                        }
                        if(statusBaak == 3){
                            status_request_baak.text = "Ditolak"
                            disetujuibaak.text = data?.namaBaak
                        }
                        if(statusKeasramaan == 3){
                            status_request_keasramaan.text = "Ditolak"
                            disetujuikeasramaan.text = data?.namaKeasramaan
                        }
                    }else if(statusDosen == 4 || statusBaak == 4 || statusKeasramaan == 4){
                        status_request_dosen_wali.text = "Dibatalkan"
                        status_request_baak.text = "Dibatalkan"
                        status_request_keasramaan.text = "Dibatalkan"
                        editIzinKeluar.visibility = View.GONE
                        cancelIzinKeluar.visibility = View.GONE
                    }else {
                        if(statusDosen == 1){
                            status_request_dosen_wali.text = "Menunggu"
                            editIzinKeluar.visibility = View.VISIBLE
                            cancelIzinKeluar.visibility = View.VISIBLE
                        }else{
                            status_request_dosen_wali.text = "Disetujui"
                            disetujuiwali.text = data?.namaDosen
                        }
                        if(statusBaak == 1){
                            status_request_baak.text = "Menunggu"
                        }else{
                            status_request_baak.text = "Disetujui"
                            disetujuibaak.text = data?.namaBaak
                        }
                        if(statusKeasramaan == 1){
                            status_request_keasramaan.text = "Menunggu"
                        }else{
                            status_request_keasramaan.text = "Disetujui"
                            disetujuikeasramaan.text = data?.namaKeasramaan
                        }
                    }
                        pbDetailIk.visibility = View.GONE
                }
            }else{
                pbDetailIk.visibility = View.GONE
                Log.d("ErrorFetchIk",response.errorBody().toString())
            }
        }
    }
}