package ta1.cis.activity

import android.content.Context
import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.util.Log
import android.view.View
import android.widget.Toast
import ta1.cis.api.RetrofitInstance
import ta1.cis.helper.SharedPref
import kotlinx.android.synthetic.main.activity_detail_izin_bermalam.*
import kotlinx.android.synthetic.main.activity_detail_izin_bermalam.topAppBar
import kotlinx.android.synthetic.main.activity_request_izin_bermalam.*
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import ta1.cis.model.response.Data
import ta1.cis.model.response.DataIzin
import ta1.cis.model.response.ResponseDetailIzinBermalam
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import retrofit2.awaitResponse
import ta1.cis.R

class DetailIzinBermalam : AppCompatActivity() {

    private lateinit var dataIzin : DataIzin

    private lateinit var sharedPref: SharedPref
    companion object{
        const val DATA_IZIN = "data_izin"
    }


    override fun onStart() {
        super.onStart()
        init()
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_detail_izin_bermalam)
        setSupportActionBar(topAppBar)
        dataIzin = intent.getParcelableExtra<DataIzin>(DATA_IZIN) as DataIzin
        sharedPref = SharedPref(this)
        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        topAppBar.setNavigationOnClickListener {
            onBackPressed()
        }
        init();
        cancelIzin.setOnClickListener {
            cancelIb()
        }
        editIzinBermalam.setOnClickListener {
            sendData(baseContext,dataIzin)
        }
    }

    fun sendData(context: Context,data: DataIzin) {
        Intent(context,EditIzinBermalam::class.java).apply {
            putExtra(EditIzinBermalam.dataIzin,data)
            putExtra("tglBerangkat",rencana_berangkat.text.toString())
            putExtra("tglKembali",rencana_kembali.text.toString())
        }.also {
            startActivity(it)
        }
    }

    fun cancelIb(){
        pb_detail.visibility = View.VISIBLE
        RetrofitInstance.instanceRetrofit.cancelIzinBermalam(dataIzin.idIzin,"Bearer ${sharedPref.getTokenBearer()}")
            .enqueue(object : Callback<Unit>{
                override fun onResponse(call: Call<Unit>, response: Response<Unit>) {
                    Toast.makeText(this@DetailIzinBermalam,"Ib sudah berhasil di batalkan", Toast.LENGTH_LONG).show()

                    pb_detail.visibility = View.GONE
                    sharedPref.setStatusUpdate(2)
                    onBackPressed()
                }

                override fun onFailure(call: Call<Unit>, t: Throwable) {

                    pb_detail.visibility = View.GONE
                    Log.d("CancelError",t.message.toString())
                    Toast.makeText(this@DetailIzinBermalam,"Ada masalah tentang koneksi Anda",Toast.LENGTH_LONG).show()
                    sharedPref.setStatusUpdate(2)
                    onBackPressed()
                }
            })
    }
    fun init(){
        var token = sharedPref.getTokenBearer()
        var dimId = sharedPref.getDimId().toLong()
        pb_detail.visibility = View.VISIBLE
        RetrofitInstance.instanceRetrofit.getDetailIzinBermalam("Bearer $token",dimId,dataIzin.idIzin!!.toLong()).enqueue(object :
            Callback<ResponseDetailIzinBermalam>{
            override fun onFailure(call: Call<ResponseDetailIzinBermalam>, t: Throwable) {
                Toast.makeText(this@DetailIzinBermalam,"Error",Toast.LENGTH_SHORT).show()
            }

            override fun onResponse(
                call: Call<ResponseDetailIzinBermalam>,
                response: Response<ResponseDetailIzinBermalam>
            ) {
                var body = response.body();
                nama_mahasiswa.text = body?.data?.nama_mahasiswa;
                nim_mahasiswa.text = body?.data?.nim_mahasiswa;
                rencana_berangkat.text = body?.data?.rencana_berangkat;
                rencana_kembali.text = body?.data?.rencana_kembali;
                realisasi_berangkat.text = body?.data?.realisasi_berangkat ?: "-";
                realisasi_kembali.text = body?.data?.realisasi_kembali ?: "-"
                keperluan_ib.text = body?.data?.keperluan_ib
                tempat_tujuan.text = body?.data?.tujuan
                when (body?.data?.request_id) {
                    1 -> {
                        status_request.text = "Menunggu"
                        cancelIzin.visibility = View.VISIBLE
                        editIzinBermalam.visibility = View.VISIBLE
                    }
                    2 -> {
                        status_request.text = "Disetujui"
                    }
                    3 -> {
                        status_request.text = "Ditolak"
                    }
                    else -> {
                        status_request.text = "Dibatalkan"
                    }
                }
                pb_detail.visibility = View.GONE
            }
        })
    }
}