#include<stdio.h>
#include<stdlib.h>
char depth[ 2056 ];
int di;

struct Node
{
	int key;
	struct Node *left;
	struct Node *right;
	int height;
};

int max(int a, int b);
int vec_left[100] = {0};
int height(struct Node *N)
{
	if (N == NULL)
		return 0;
	return N->height;
}

int max(int a, int b)
{
	return (a > b)? a : b;
}

struct Node* newNode(int key)
{
	struct Node* node = (struct Node*) malloc(sizeof(struct Node));
	node->key = key;
	node->left = NULL;
	node->right = NULL;
	node->height = 1;
	return(node);
}

struct Node *rightRotate(struct Node *y)
{
	struct Node *x = y->left;
	struct Node *T2 = x->right;

	x->right = y;
	y->left = T2;

	y->height = max(height(y->left), height(y->right))+1;
	x->height = max(height(x->left), height(x->right))+1;

	return x;
}

struct Node *leftRotate(struct Node *x)
{
	struct Node *y = x->right;
	struct Node *T2 = y->left;

	y->left = x;
	x->right = T2;

	x->height = max(height(x->left), height(x->right))+1;
	y->height = max(height(y->left), height(y->right))+1;

	return y;
}

int getBalance(struct Node *N)
{
	if (N == NULL)
		return 0;
	return height(N->left) - height(N->right);
}

struct Node* search(struct Node* node, int key){
	struct Node* current = node;

	if(node == NULL) return 0;
	else if(key < node->key) return search(node->left, key);
	else if(key > node->key) return search(node->right, key);

	// while(current != NULL){
	// 	if(key > current->key){
	// 		current = current->right;
	// 	}else{
	// 		current = current->left;
	// 	}
	// }
	// return current;
}

struct Node* insert(struct Node* node, int key)
{
	if (node == NULL)
		return(newNode(key));

	if (key < node->key)
		node->left = insert(node->left, key);
	else if (key > node->key)
		node->right = insert(node->right, key);
	else 
		return node;

	node->height = 1 + max(height(node->left), height(node->right));

	int balance = getBalance(node);

	// Left Left 
	if (balance > 1 && key < node->left->key)
		return rightRotate(node);

	// Right Right 
	if (balance < -1 && key > node->right->key)
		return leftRotate(node);

	// Left Right 
	if (balance > 1 && key > node->left->key)
	{
		node->left = leftRotate(node->left);
		return rightRotate(node);
	}

	// Right Left 
	if (balance < -1 && key < node->right->key)
	{
		node->right = rightRotate(node->right);
		return leftRotate(node);
	}

	return node;
}

struct Node *balanceTree(struct Node* node, int key){
	node->height = 1 + max(height(node->left), height(node->right));

	int balance = getBalance(node);

	if(balance > 1 && key < node->left->key){
		return rightRotate(node);
	}
	else if(balance < -1 && key > node->right->key){
		return leftRotate(node);
	}
	else if(balance > 1 && key > node->left->key){
		node->left = leftRotate(node->left);
		return rightRotate(node);
	}
	else if(balance < -1 && key < node->right->key){
		node->right = rightRotate(node->right);
		return leftRotate(node);
	}
	else{
		return node;
	}
}

struct Node * minValueNode(struct Node* node)
{
	struct Node* current = node;

	while (current->left != NULL)
		current = current->left;

	return current;
}

struct Node* deleteNode(struct Node* root, int key)
{
	if (root == NULL)
		return root;
	if ( key < root->key )
		root->left = deleteNode(root->left, key);
	else if( key > root->key )
		root->right = deleteNode(root->right, key);
	else
	{
		if( (root->left == NULL) || (root->right == NULL) )
		{
			struct Node *temp = root->left ? root->left : root->right;
			if (temp == NULL)
			{
				temp = root;
				root = NULL;
			}
			else
			*root = *temp; 
			free(temp);
		}
		else
		{
			struct Node* temp = minValueNode(root->right);

			root->key = temp->key;

			root->right = deleteNode(root->right, temp->key);
		}
	}

	if (root == NULL)
	return root;

	root->height = 1 + max(height(root->left), height(root->right));

	int balance = getBalance(root);

	// Left Left 
	if (balance > 1 && getBalance(root->left) >= 0)
		return rightRotate(root);

	// Left Right 
	if (balance > 1 && getBalance(root->left) < 0)
	{
		root->left = leftRotate(root->left);
		return rightRotate(root);
	}

	// Right Right 
	if (balance < -1 && getBalance(root->right) <= 0)
		return leftRotate(root);

	// Right Left 
	if (balance < -1 && getBalance(root->right) > 0)
	{
		root->right = rightRotate(root->right);
		return leftRotate(root);
	}

	return root;
}

void Push( char c )
{
	depth[ di++ ] = ' ';
	depth[ di++ ] = c;
	depth[ di++ ] = ' ';
	depth[ di++ ] = ' ';
	depth[ di ] = 0;
}

void Pop( )
{
	depth[ di -= 4 ] = 0;
}

void Print( struct Node* tree )
{
	printf( "(%d)\n", tree->key );

	if ( tree->left )
	{
		printf( "%s `--", depth );
		Push( '|' );
		Print( tree->left );
		Pop( );

		printf( "%s `--", depth );
		Push( ' ' );
		Print( tree->right );
		Pop( );
	}
}

void preOrder(struct Node *root)
{
	if(root != NULL)
	{
		printf("%d ", root->key);
		preOrder(root->left);
		preOrder(root->right);
	}
}
void delay() {
    int delay = 0;
    while(delay < 400000000) {
        delay++;
	}
}

void Display(struct Node *root, int indent){
	if(indent > 0){
		for(int i = 0; indent-1; ++i){
			printf(vec_left[i] ? "│   " : "    ");
		}
		printf(vec_left[indent-1] ? "├── " : "└── ");
	}

	if(!root){
		printf("(null)\n");
		return;
	}

	printf("%d\n", root->key);
    if(!root->left && !root->right)
    {
        return;
    }
 
    vec_left[indent] = 1;
    Display(root->left, indent + 1);
    vec_left[indent] = 0;
    Display(root->right, indent + 1);
}

void findPreSuc(struct Node* root, struct Node* pre, struct Node* suc, int key)
{
    // Base case
    if (root == NULL)  return ;
 
    // If key is present at root
    if (root->key == key)
    {
        // the maximum value in left subtree is predecessor
        if (root->left != NULL)
        {
            struct Node* tmp = root->left;
            while (tmp->right)
                tmp = tmp->right;
            pre = tmp ;
        }
 
        // the minimum value in right subtree is successor
        if (root->right != NULL)
        {
            struct Node* tmp = root->right ;
            while (tmp->left)
                tmp = tmp->left ;
            suc = tmp ;
        }
        return ;
    }
 
    // If key is smaller than root's key, go to left subtree
    if (root->key > key)
    {
        suc = root ;
        findPreSuc(root->left, pre, suc, key) ;
    }
    else // go to right subtree
    {
        pre = root ;
        findPreSuc(root->right, pre, suc, key) ;
    }
}


int main()
{
	struct Node *root = NULL;
	struct Node* pre = NULL, *suc = NULL;
	while(1==1){
		printf("Selamat datang");
	printf("=========================================================\n");
	printf("1. Insert Data\n");
	printf("2. Print Data\n");
	printf("3. Cari Data\n");
	printf("4. Delete Data\n");
	printf("5. Keluar\n");
	printf("=========================================================\n");
	int choice;
	printf("Pilih Menu : ");
	scanf("%d",&choice);
	if(choice == 1){
		int quantity;
		printf("Jumlah Data yang ingin dimasukkan: ");
		scanf("%d",&quantity);
		int arr[quantity];
		int i;
		for(i = 0 ; i < quantity; i++){
			int input;
			printf("Data ke-%d : ",(i+1));
			scanf("%d",&input);
			root = insert(root,input);
		}
		printf("Data Berhasil di masukkan\n");
		//	root = insert(root, 1);
		//	root = insert(root, 2);
		//	root = insert(root, 3);
		//	root = insert(root, 4);
		//	root = insert(root, 5);
	}
	else if(choice == 2){
		printf("Berikut List Data\n");
		printf("Pre Order:\n");
		preOrder(root);
		printf("\n");
		Print(root);
	}
	else if(choice == 3){
		int look;
		printf("Angka yang mau dicari : ");
		scanf("%d",&look);
		printf("Sedang mencari angka %d\n",look);
		delay();
		if(search(root, look)){
			printf("Angka %d terdapat dalam Tree", look);
		}else{
			printf("Angka %d tidak terdapat dalam Tree", look);
		}
		printf("\n");
		findPreSuc(root, pre, suc, look);
		if(pre != NULL){
			printf("Predecessor : %d\n", pre->key);
		}else{
			printf("No Predecessor\n");
		}

		if(suc != NULL){
			printf("Successor : %d\n", suc->key);
		}else{
			printf("No Successor\n");
		}
	}else if(choice == 4){
		
		int look; 
		printf("Angka yang mau dihapus : ");
		scanf("%d",&look);

		printf("Sedang menghapus angka %d\n",look);
		delay();
		printf("Angka %d berhasil dihapus",look);
		root = deleteNode(root, look);
		preOrder(root);
		printf("\n");
		printf("\n");
	}else{
		exit(0);
	}
	printf("\n");
	}
	return 0;
}
