<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class PetaniController extends Controller
{
    public function index()
    {
    	$data_petani = \App\Petani::all();
    	return view('petani.index',['data_petani' => $data_petani]);
    } 

    public function create(Request $request)
    {
    	\App\Petani::create($request->all());
    	return redirect('/petani')->with('sukses', 'Data berhasil diinput');

    }

    public function edit($id)
    {
    	$petani = \App\Petani::find($id);
    	return view('petani/edit',['petani' => $petani]);
    }

    public function update(Request $request,$id)
    {
    	$petani = \App\Petani::find($id);
    	$petani->update($request->all());
    	return redirect('/petani')->with('sukses', 'Data berhasil diupdate');

    }

    public function delete($id)
    {
    	$petani = \App\Petani::find($id);
    	$petani->delete($petani);
    	return redirect('/petani')->with('sukses', 'Data berhasil dihapus');
    }

}