<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CommentController extends Controller
{
    public function index($id){
      $komentar = DB::table('comments')
                    ->join('perusahaans', 'comments.perusahaan_id', '=', 'perusahaans.id')
                    ->join('users', 'comments.user_id', '=', 'users.id')
                    ->select('users.username', 'perusahaans.*', 'comments.body')
                    ->where('perusahaans.id', $id)
                    ->get();

      $perusahaan = DB::table('perusahaans')->where(['id' => $id])->get();
      // passing data pegawai yang didapat ke view edit.blade.php
      return view('komentar',['perusahaan' => $perusahaan]);
    }

    public function tambah(Request $request)
    {
    // insert data ke table komentar
      DB::table('comments')->insert([
        'user_id' => $request->user()->id,
        'perusahaan_id' => $request->id_perusahaan,
        'body' => $request->body,
      ]);
    // alihkan halaman ke halaman komentar

    // $tampilkan_data = Auth::user()->data()->paginate(10);
    // $jumlah_data = count($tampilkan_data['data']);
    return redirect('/index');
    }

    public function keFormKomentar($id){

      $perusahaan = DB::table('perusahaans')->where(['id' => $id])->get();
      return view('formKomentar', ['perusahaan' => $perusahaan]);
    }
}
